/*
 * Sets MIME environ
 */

#include "modskel.h"
#include <unistd.h>

#define DEFAULT_MIMETYPE "${PREFIX}/share/screws/mime.types"
MODULE_TYPE(MTYPE_ENV);
MODULE_NAME("Mime");
MODULE_VERS("0.3");

char *mimefile=0;

bool init() /* Init function */
{
	MODULE_INIT();

	/* default mimetype not found. Use user defined MIMEFILE */
	if (getenv("MIMEFILE"))
	{
		mimefile=getenv("MIMEFILE");
	}
	if (access(mimefile,R_OK))
	{
		/* check default mimetype */
		if (! access(DEFAULT_MIMETYPE,R_OK) )
		{
			printf("   (!) Using default mime '%s'\n",mimefile);
			mimefile=DEFAULT_MIMETYPE;
		} else {
			printf("   (!) Cannot open '%s'. Please solve that.\n",mimefile);
		}
	}
	setenv("MIME","text/html",1);

	return true;
}

bool screws_module_mime(char *filetype)
{
	FILE *fd;
	char buf[1024];
	char ext[10][20];
	char mime[100];
	register int i;

	if (!filetype)
		return true;

	fd=fopen(mimefile,"r");
	if (fd) {
		//filetype=getenv("FILETYPE");
		while(!feof(fd))
		{
			for(i=0;i<10;i++)ext[i][0]=0;
			fgets(buf,1000,fd);
			sscanf(buf,"%s %s %s %s %s %s %s %s %s %s %s",mime,
				ext[0],ext[1],ext[2],ext[3],ext[4],
				ext[5],ext[6],ext[7],ext[8],ext[9]);
			for (i=0;i<10&&ext[i][0];i++)
				if (!strcmp(filetype,ext[i]))
				{
				setenv("MIME",mime,1);
				return false;
				}
		}
		fclose(fd);
	} else {
			// Yet informed in init()
			printf("Cannot read mime file '%s'.\n",mimefile);
	}
	return false;
}

void screws_module_mime_fromfile(char *fe)
{
	int i;
	char file[1024];
strcpy(file,fe); // TMP


	for(i=0;file[i]&&file[i]!='.';i++);
	if (file[i]=='.')
		{
		screws_module_mime(file+i+1);
		file[i]='.';
		}
}



bool exec(char **opts) /* Exec function */
{
	setenv("MIME","text/html",1);

	return screws_module_mime( getenv("FILETYPE") );
}
