/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Manage configuration variables:
   Auto-generate GUI to configure these variables, all of which are python dictionaries

   C. Steenberg 7/12/2000
*/

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include <scigraphica/sg.h>
#include "sg_config_dialog.h"

static void def_modules_apply(GtkWidget *wlist);
static void def_paths_apply(GtkWidget *wlist);
extern GtkWidget *main_window;


static sg_config_info py_var_info[]={
        { DIALOG_SEP,NULL,NULL,NULL,NULL,"Configuration"},
        { NOTEBOOK_START,NULL,NULL,NULL,NULL,NULL},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Module paths"},
        { DICT_LIST, "path", "module",&def_paths_apply,NULL,"Filesystem paths to search for modules"},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Startup"},
        { DICT_LIST, "startup", "module",&def_modules_apply,NULL,"Modules to import upon startup"},
        { NOTEBOOK_END,NULL,NULL,NULL,NULL,NULL},
        { END_CONFIG,NULL,NULL,NULL,NULL,NULL}
};

static void 
def_paths_apply(GtkWidget *wlist)
{ 
  gint i,num=-1;
  gchar *text;
  PyObject *dict=NULL;

  for  (i=0;py_var_info[i].type!=END_CONFIG;i++)
   if (py_var_info[i].data_out==wlist)
    {
      dict=sg_config_get_value(py_var_info[i].config_name,py_var_info[i].config_group);
      break;
    }

  num=i;
  if (!dict) return;

  PyDict_Clear(dict);

  for (i=0;gtk_clist_get_text(GTK_CLIST(wlist),i,0,&text)>0;i++)
      PyDict_SetItemString(dict,text,Py_None);

  sg_config_exec_commit(sg_config_get_config(py_var_info[num].config_name,py_var_info[num].config_group));

}


static void 
def_modules_apply(GtkWidget *wlist)
{ 
  PyObject *keys,*key_name,*item,*dict;
  gint i,j,newflag=SG_MODULE_LOAD_MAIN,flag;
  gchar *text;

  dict=sg_config_get_value("startup", "module");
  keys=PyDict_Keys(dict);
  for (j=0;j<PyList_GET_SIZE (keys);j++)
   { key_name=PyList_GetItem (keys,j);
     flag=(gint)PyInt_AsLong (PyDict_GetItem (dict,key_name));
     if (! (flag&SG_MODULE_LOAD_REQ))
       PyDict_DelItem(dict,key_name);

   }

  for (i=0;gtk_clist_get_text(GTK_CLIST(wlist),i,0,&text)>0;i++)
   { item=PyDict_GetItemString(dict,text);
     if (!item)
      PyDict_SetItemString(dict,text,PyInt_FromLong ((long)newflag));
   }
  sg_config_exec_commit(sg_config_get_config("startup", "module"));

}

void 
sg_python_config_dialog(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog;
  dialog = sg_config_dialog(py_var_info);
  sg_dialog_run(dialog, GTK_OBJECT(main_window));
}

