/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>  
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_main.h"
#include "sg_project_config.h"
#include "sg_project_autosave.h"

extern PyObject *sys_dict,
                *main_dict,
		*sg_dict;

extern SGapplication *app;

extern gint sg_autosave_interval;
extern gint sg_compress_level;

gboolean sg_show_plot_toolbar = TRUE;
gboolean sg_show_plot_menubar = TRUE;
gboolean sg_show_toolbar_labels = TRUE;

static gint init_canvas_labels_pos(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_canvas_label_pos),FALSE);
  return TRUE;
}
                                                                                
static gint commit_canvas_labels_pos(SGconfig *config)
{
  gint pos;
                                                                                
  pos=(gint)PyInt_AsLong(sg_config_get_value(config->name, config->group));
  sg_canvas_label_pos=pos;
                                                                                
  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist1));
  gtk_icon_list_set_mode(GTK_ICON_LIST(iconlist1), pos + 1);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist1));
  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist2));
  gtk_icon_list_set_mode(GTK_ICON_LIST(iconlist2), pos + 1);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist2));
                                                                                
  return TRUE;
}
                                                                                
static gint init_canvas_labels_width(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_canvas_label_width),FALSE);
  return TRUE;
}

static gint commit_canvas_labels_width(SGconfig *config)
{
    gint width;
                                                                                
    width=(gint)PyInt_AsLong(sg_config_get_value(config->name, config->group));
    sg_canvas_label_width=width;
                                                                                
    gtk_icon_list_freeze(GTK_ICON_LIST(iconlist1));
    gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist1), width);
    gtk_icon_list_thaw(GTK_ICON_LIST(iconlist1));
                                                                                
    gtk_icon_list_freeze(GTK_ICON_LIST(iconlist2));
    gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist2), width);
    gtk_icon_list_thaw(GTK_ICON_LIST(iconlist2));
                                                                                
    return TRUE;
}

static gint init_show_labels(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_show_toolbar_labels), TRUE);
  return TRUE;
}                                                                               

static gint commit_show_labels(SGconfig *config)
{
  gint show;
  GList *list;
  GtkWidget *toolbar;
                                                                                
  show = (gint)PyInt_AsLong(sg_config_get_value(config->name, config->group));
  sg_show_toolbar_labels = show;

  toolbar = gtk_object_get_data(GTK_OBJECT(app),"menubar");
  if(toolbar) gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), show?GTK_TOOLBAR_BOTH:GTK_TOOLBAR_ICONS); 

  list = app->plots->list;
  while (list)
  { 
    SGlistChild *child = (SGlistChild *)list->data;
    SGplotWindow *window;
    SGplot *plot;

    plot = SG_PLOT(child->object);
    window = SG_PLOT_WINDOW(gtk_object_get_data(GTK_OBJECT(plot), "window"));
    toolbar = gtk_object_get_data(GTK_OBJECT(window),"menubar");
    if(toolbar) gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), show?GTK_TOOLBAR_BOTH:GTK_TOOLBAR_ICONS); 
    list = list->next;
  } 

  list = app->worksheets->list;
  while (list)
  { 
    SGlistChild *child = (SGlistChild *)list->data;
    SGworksheetWindow *window;
    SGworksheet *w;

    w = SG_WORKSHEET(child->object);
    window = SG_WORKSHEET_WINDOW(gtk_object_get_data(GTK_OBJECT(w), "window"));
    toolbar = gtk_object_get_data(GTK_OBJECT(window),"menubar");
    if(toolbar) gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), show?GTK_TOOLBAR_BOTH:GTK_TOOLBAR_ICONS); 
    list = list->next;
  } 
                                                                                
  return TRUE;
}
 
static gint init_show_plot_toolbar(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_show_plot_toolbar),FALSE);
  return TRUE;
}
                                                                                
static gint commit_show_plot_toolbar(SGconfig *config)
{
  gint show;
  GList *list;
                                                                                
  show = (gint)PyInt_AsLong(sg_config_get_value(config->name, config->group));
  sg_show_plot_toolbar = show;

  list = app->plots->list;
  while (list)
  { 
    SGlistChild *child = (SGlistChild *)list->data;
    SGplotWindow *window;
    SGplot *plot;

    plot = SG_PLOT(child->object);
    window = SG_PLOT_WINDOW(gtk_object_get_data(GTK_OBJECT(plot), "window"));

    sg_plot_window_set_toolbar_visible(window, show);
    list = list->next;
  } 
                                                                                
  return TRUE;
}
                                                                                
static gint init_show_plot_menubar(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_show_plot_menubar),FALSE);
  return TRUE;
}
                                                                                
static gint commit_show_plot_menubar(SGconfig *config)
{
  gint show;
  GList *list;
                                                                                
  show=(gint)PyInt_AsLong(sg_config_get_value(config->name, config->group));
  sg_show_plot_menubar = show;
                                                                                
  list = app->plots->list;
  while (list)
  { 
    SGlistChild *child = (SGlistChild *)list->data;
    SGplotWindow *window;
    SGplot *plot;

    plot = SG_PLOT(child->object);
    window = SG_PLOT_WINDOW(gtk_object_get_data(GTK_OBJECT(plot), "window"));

    sg_plot_window_set_menubar_visible(window, show);
    list = list->next;
  } 
                                                                                
  return TRUE;
}

static gint init_save_interval(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong((long)sg_autosave_interval),FALSE);
  return TRUE;
}
                                                                                
static gint commit_save_interval(SGconfig *config)
{
  PyObject *value;
  value=sg_config_get_value(config->name, config->group);
  sg_autosave_interval=(gint)PyInt_AsLong(value);
                                                                                
  sg_project_autosave_set(sg_autosave_interval);
                                                                                
  return TRUE;
}
                                                                                
                                                                                
static gint init_compress_level(SGconfig *config)
{
  sg_config_set_value(config->name, config->group,
                      PyInt_FromLong ((long) sg_compress_level),FALSE);
  return TRUE;
}
                                                                                
static gint commit_compress_level(SGconfig *config)
{
  PyObject *value;
  value=sg_config_get_value(config->name, config->group);
  sg_compress_level=(gint)PyInt_AsLong(value);
  return TRUE;
}


/* Create groups hashtable, and optionally the python config_dict */
void
sg_project_config_init()
{
  sg_config_new_c("show_labels", "maingui", init_show_labels, commit_show_labels);
  sg_config_new_c("label_width", "maingui", init_canvas_labels_width, commit_canvas_labels_width);
  sg_config_new_c("label_pos", "maingui", init_canvas_labels_pos, commit_canvas_labels_pos);
  sg_config_new_c("save_interval", "file", init_save_interval, commit_save_interval);
  sg_config_new_c("compress_level", "file", init_compress_level, commit_compress_level);
  sg_config_new_c("show_toolbar", "plotgui", init_show_plot_toolbar, commit_show_plot_toolbar);
  sg_config_new_c("show_menubar", "plotgui", init_show_plot_menubar, commit_show_plot_menubar);
}

