/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_MAIN_H__
#define __SG_MAIN_H__

#include <stdlib.h>
#include <gtkextra/gtkextra.h>

#include <scigraphica/sg.h> 
#include "config.h"
#include "sg_project_statusbar.h" 
#include "sg_project_rescue.h" 
#include "sg_project_autosave.h" 
#include "sg_project_menu.h" 
#include "sg_project_popups.h" 
#include "sg_project_toolbar.h" 

typedef enum {
     SG_GUI_ICONLIST,
     SG_GUI_WORKSHEET,
     SG_GUI_PLOT
} SGguiMode;

extern SGguiMode gui_mode;
extern GtkWidget *gui_notebook;
extern GtkWidget *iconlist1;
extern GtkWidget *iconlist2;
extern GtkIconListItem *active_icon;
extern GtkWidget *main_window;
extern SGapplication *app;
extern gint sg_canvas_label_pos;
extern gint sg_canvas_label_width;

gint main_quit (GtkWidget *widget);

#endif /* __SG_MAIN_H__ */
