/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_main.h"
#include "pixmaps/logo.xpm"
#include "config.h"

static guint32 timer;

static gboolean
presentation_destroy(GtkWidget *widget)
{
  gtk_timeout_remove(timer);

  return FALSE;
}


static gboolean
timeout_end(gpointer data)
{
  gtk_timeout_remove(timer);

  if(GTK_IS_WIDGET(data)) gtk_widget_destroy(GTK_WIDGET(data));

  gtk_main_quit();

  return FALSE;
}


void
sg_about_dialog ()
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GtkWidget *dialog;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar text[1000];

  colormap = gdk_colormap_get_system();

  window = sg_dialog_new (_("SciGraphica: About"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK, GTK_BUTTONBOX_SPREAD );
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);

  dialog = sg_property_dialog_new();
  sg_dialog_add(window, SG_PROPERTY_DIALOG(dialog));
  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (dialog), main_box);

  table = gtk_table_new(3, 1, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            frame,
                            0, 1, 0, 1);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 logo_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(frame), tpixmap);

  sprintf(text, _("SciGraphica-%s\nScientific Graphics\n\n(C) 2000 Adrian E. Feiguin\n\nhttp://scigraphica.sourceforge.net\n\nAuthors\nAdrian E. Feiguin <feiguin@magnet.fsu.edu>\nConrad Steenberg <conrad@hep.caltech.edu>") , VERSION);

  label =  gtk_label_new(text);
  gtk_misc_set_alignment(GTK_MISC(label), .5, .5);

  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  sg_dialog_run(window, GTK_OBJECT(main_window));

  return;
}

void
sg_presentation_dialog ()
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar text[1000];

  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window), "SciGraphica");
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_container_add (GTK_CONTAINER (window), frame);


  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);
  gtk_container_add (GTK_CONTAINER (frame), main_box);

  table = gtk_table_new(3, 1, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            frame,
                            0, 1, 0, 1);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 logo_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(frame), tpixmap);

  sprintf(text, _("SciGraphica-%s\nScientific Graphics\n\n(C) 2000 Adrian E. Feiguin\n\nhttp://scigraphica.sourceforge.net") , VERSION);

  label =  gtk_label_new(text);
  gtk_misc_set_alignment(GTK_MISC(label), .5, .5);

  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  /* connect signals */

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (presentation_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  timer = gtk_timeout_add(1200, timeout_end, window); 

  gtk_main();

  return;
}


