/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_CONFIG_DIALOG_H__
#define __SG_CONFIG_DIALOG_H__


#include <Python.h>
#include <glib.h>
#include <scigraphica/sg_config.h> 

/* Flags for module loading */
enum {SG_MODULE_LOAD_MAIN = 1 << 0,      /* Load module dict into main dictionary */
      SG_MODULE_LOAD_SYMBOLS = 1 << 1,   /* Load module's symbols into main dictionary */
      SG_MODULE_LOAD_REQ = 1 << 2 }; /* This module is required for normal operation of SG */

typedef enum {
        END_CONFIG,
        DIALOG_SEP,
        NOTEBOOK_START,
        NOTEBOOK_END,
        PAGE_SEP,
        FRAME_START,
        FRAME_END,
        DICT_LIST,
        DICT_PATH_LIST,
        DICT_INT,
        DICT_INT_BOUND,
        DICT_INT_BOUND_SLIDER,
        DICT_DOUBLE,
        DICT_DOUBLE_BOUND,
        DICT_TOGGLE,
        DICT_MENU,
        DICT_BOOLEAN
} config_id;

typedef struct _sg_config_info{
  config_id type;
  gchar *config_name;
  gchar *config_group;
  gpointer data_in;
  gpointer data_out;
  gchar *name;
} sg_config_info;

typedef struct _sg_menu_info
{       
  gchar **options;
  gpointer init_func;
  gpointer apply_func;
} sg_menu_info;

typedef struct _sg_bound_int_info
{
  gfloat min;
  gfloat max;
  gpointer init_func;
  gpointer apply_func;
} sg_bound_int_info;

GtkWidget * sg_config_dialog	(sg_config_info *var_info);

#endif /* __SG_CONFIG_DIALOG_H__ */

