/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_main.h"

GtkWidget *
sg_project_toolbar_new(SGapplication *app)
{
  GtkWidget *tb, *hb;
  SGpluginMenu *plugin;
  GList *list;

  tb = gtk_toolbar_new();
  hb = gtk_handle_box_new();
  gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(hb), GTK_POS_LEFT);
  gtk_container_set_border_width(GTK_CONTAINER(hb), 0);
  gtk_widget_show(hb);
  gtk_container_add(GTK_CONTAINER(hb), tb);
                                                                                
  gtk_object_set_data(GTK_OBJECT(tb), "application", app);
  gtk_object_set_data(GTK_OBJECT(app), "menubar", tb);
                                                                                
  list = sg_plugins();
  while(list){
    SGplugin *plugin = SG_PLUGIN(list->data);
    if(GTK_IS_SG_PLUGIN_MENU(plugin)){
      if(strcmp(SG_PLUGIN_MENU(plugin)->owner_id, "project:toolbar") == 0)
        sg_toolbar_add_plugin(tb, SG_PLUGIN_MENU(plugin));
    }
                                                                                
    list = list->next;
  }
                                                                                
  return hb;
}
