/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/dialogs/sg_misc_dialogs.h>
#include "sg_main.h"

GtkWidget *worksheet_popup;
GtkWidget *plot_popup;
GtkIconListItem *active_icon;

void
sg_worksheet_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
  active_icon = item;

  gtk_menu_popup(GTK_MENU(worksheet_popup), NULL, NULL, NULL, NULL,
                 event->button, event->time);
}

void
sg_plot_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
  active_icon = item;

  gtk_menu_popup(GTK_MENU(plot_popup), NULL, NULL, NULL, NULL,
                 event->button, event->time);
}


static void
plot_popup_activated(GtkWidget *widget, gpointer data)
{
  gchar *item;
  GtkIconList *iconlist;
  SGplot *plot;
 
  item = (gchar *)data;
  iconlist = GTK_ICON_LIST(iconlist2);
 
  plot =  SG_PLOT_WINDOW(gtk_icon_list_get_link(active_icon))->plot;
 
  if(strcmp(item, _("Open") )==0)
    gtk_widget_show(GTK_WIDGET(plot));
 
  if(strcmp(item, _("Remove") )==0){
    gchar message[100]; 
    
    sprintf(message, _("Remove %s ?"), plot->name);
    if( sg_accept_dialog(message, 1) != SG_BUTTON_YES ) return;
 
    sg_application_remove_plot(app, plot);
  }
 
  if(strcmp(item, _("Rename") )==0)
    gtk_icon_list_set_active_icon(iconlist, active_icon);

}

static void
worksheet_popup_activated(GtkWidget *widget, gpointer data)
{
  gchar *item;
  GtkIconList *iconlist;
  SGworksheet *worksheet;
 
  item = (gchar *)data;
  iconlist = GTK_ICON_LIST(iconlist1);
 
  worksheet = SG_WORKSHEET_WINDOW(gtk_icon_list_get_link(active_icon))->worksheet;
 
  if(strcmp(item, _("Open") )==0)
    gtk_widget_show(GTK_WIDGET(worksheet));
 
  if(strcmp(item, _("Remove") )==0){
    gchar text[100];
 
    sprintf(text, _("Remove %s ?"), worksheet->name);
    if( sg_accept_dialog(text, 1) != SG_BUTTON_YES ) return;
 
    sg_application_remove_worksheet(app, worksheet);
  }
 
  if(strcmp(item, _("Rename") )==0)
    gtk_icon_list_set_active_icon(iconlist, active_icon);
 
}


void
sg_project_popups_build()
{
  char *popup_items[]={ _("Open"),
                        _("Rename"),
                        _("Remove") };
  GtkWidget *item;
  unsigned int i;

  worksheet_popup = gtk_menu_new();

  for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
          item=gtk_menu_item_new_with_label(popup_items[i]);
          gtk_signal_connect(GTK_OBJECT(item),"activate",
                             (GtkSignalFunc) worksheet_popup_activated,
                             popup_items[i]);
          gtk_widget_show(item);
          gtk_menu_append(GTK_MENU(worksheet_popup),item);
  }

  plot_popup = gtk_menu_new();

  for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
          item=gtk_menu_item_new_with_label(popup_items[i]);
          gtk_signal_connect(GTK_OBJECT(item),"activate",
                             (GtkSignalFunc) plot_popup_activated,
                             popup_items[i]);
          gtk_widget_show(item);
          gtk_menu_append(GTK_MENU(plot_popup),item);
  }
}


