.\" Man page for SciGraphica.
.\" Use the following command to view man page:
.\"
.\"  tbl scigraphica.1 | nroff -man | less
.\"
.TH SCIGRAPHICA 0.8.1 "December 2001" "Version 0.8.1" "SciGraphica 0.8.1"
.SH NAME
SciGraphica \- A scientific application for data analysis and technical graphics
.\"
.\" setup
.de Cr
.ie n (c)
.el \(co
..
.SH SYNOPSIS
\fBscigraphica\fR [\fIoptions\fR] [\fIfile ...\fR]
.br
.SH DESCRIPTION
\fBSciGraphica\fR is too complex to cover completely in these manual pages.
If your system is properly configured, you can access the full
documentation within \fBSciGraphica\fR under the Help menu.

\fBSciGraphica\fR is a scientific application for data analysis and technical
graphics. It pretends to be a clone of the commercial (and for MS-Windows only)
application "Microcal Origin". The aim is to obtain a fully-featured, cross-platform,
user-friendly, self-growing scientific application. It fully supplies plotting
features for 2D, 3D and polar charts. It is free and open-source, released under
the GPL license.
 
\fBSciGraphica\fR uses the \fBGtk+ Library\fR as a toolkit (with optional
\fBGnome\fR support). \fBSciGraphica\fR should run on any platform, where
Gtk+ runs. This is on all major Unix and Unix-type platforms, such as HP-UX,
IRIX, GNU/Linux and FreeBSD.

.SH OPTIONS
\fBSciGraphica\fR supports the following command-line options:
.TP 6
.BI \-w[\fR=\fIname\fB]\ \fRor\ \fB\-\-worksheet[\fR=\fIname\fB]
Starts \fBSciGraphica\fR in worksheet mode and optionally renames
the worksheet to \fIname\fR. 
.TP
.BI \-p[\fR=\fIname\fB]\ \fRor\ \fB\-\-plot[\fR=\fIname\fB]
Starts \fBSciGraphica\fR in plot mode and optionally renames the
plot to \fIname\fR.
.TP
.BI \-v\ \fRor\ \fB\-\-version
Shows version information on the build of \fBSciGraphica\fR.
.TP
\fBSciGraphica\fR supports also the following generic command-line \
options from the \fBGtk+ Library\fR:
.TP
.BI \-\-help
Shows help message on Gtk+, GUI and Gnome options (only available
when compiled with Gnome support).
.TP
.BI \-\-gtk-module\fR=\fIMODULE
Loads an additional Gtk module.
.TP
.BI \-\-g-fatal\-warning
Makes all warnings fatal.
.TP
.BI \-\-gtk\-debug\fR=\fIFLAGS
Gtk+ debugging flags to set.
.TP
.BI \-\-gtk\-no\-debug\fR=\fIFLAGS
Gtk+ debugging flags to unset.
.TP
.BI \-\-display\fR=\fIDISPLAY
X display to use.
.TP
.BI \-\-sync
Makes X calls synchronous.
.TP
.BI \-\-no\-xshm
Don't use X shared memory extension.
.TP
.BI \-\-name\fR=\fINAME
Program name as used by the window manager.
.TP
.BI \-\-class\fR=\fICLASS
Program class as used by the window manager.

.SH ENVIRONMENT
.TP
.B SG_ROOT
specifies the \fBSciGraphica\fR installation directory (by
default /usr/local on Unix systems)
.TP
.B SG_DOCVIEWER
specifies the html document viewer/browser for \fBSciGraphica\fR

.SH FILES
.TP
~/.scigraphica/config
System generated configuration file
.TP
\fISHARE\fR/gnome/help/scigraphica/<locale>/
directory containing help documentation in HTML format
.TP
\fISHARE\fR/scigraphica/examples/
directory containing \fBSciGraphica\fR and \fBpython\fR example files
.TP
\fISHARE\fR/scigraphica/python/
directory containing \fBpython\fR modules for \fBSciGraphica\fR
.TP
\fISHARE\fR/pixmaps/scigraphica/
directory containing pixmaps used by \fBSciGraphica\fR
.TP
\fISHARE\fR/locale/<locale>/LC_MESSAGES/scigraphica.mo
file with locale translations of \fBSciGraphica\fR messages
.TP	
\fISHARE\fR is the \fBSciGraphica\fR system directory. \
The default is SG_ROOT/share (/usr/local/share) \
on UNIX systems.

.SH SEE ALSO
\fBpython\fR(1).

Full documentation is available in either SGML or HTML format.

The homepage of \fBSciGraphica\fR and its most recent version can be found at
http://scigraphica.sourceforge.net/

.SH BUGS/LIMITATIONS
There are probably still bugs in \fBSciGraphica\fR. Please report them to
scigraphica-devel@lists.sourceforge.net with detailed info, including which
version of \fBSciGraphica\fR you use. Consult the bug-reporting instructions in the
documentation (accessible from the Help menu in \fBSciGraphica\fR) first if possible.

.SH AUTHORS
Copyright
.Cr
2000 by Adrian E. Feiguin
(feiguin@magnet.fsu.edu) and the rest of the \fBSciGraphica Team\fR
(see credits in the documentation).
