/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <signal.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include <scigraphica/widgets/sg_dialog.h>
#include <scigraphica/dialogs/sg_misc_dialogs.h>
#include <scigraphica/sg_file_dialog.h>
#include "sg_project.h"
#include "sg_project_autosave.h"
#include "sg_config_dialog.h"
#include "sg_preferences_dialog.h"
#include "sg_python_config.h"
#include "sg_logo_dialogs.h"
#include "pixmaps/new_small.xpm"
#include "pixmaps/open_small.xpm"
#include "pixmaps/save_small.xpm"
#include "pixmaps/save_as_small.xpm"
#include "pixmaps/about_small.xpm"
#include "pixmaps/exit_small.xpm"
#include "pixmaps/sheet_small.xpm"
#include "pixmaps/new_2d_small.xpm"
#include "pixmaps/new_3d_small.xpm"
#include "pixmaps/new_polar_small.xpm"
#include "pixmaps/python_small.xpm"
#include "pixmaps/preferences_small.xpm"
#include "pixmaps/book_small.xpm"
#include "pixmaps/sg_small.xpm"

extern gchar *last_project_path;
extern gchar *last_project_filename;

void sg_menu_save(GtkWidget *widget, GtkWidget *menu, gpointer data);

void
create_pixmap(SGplugin *_plugin, gchar **data)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
                                                                                
  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, data);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
                                                                                
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
                                                                                
void
sg_menu_exit(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));

  if(sg_application_changed(SG_APPLICATION(data))){
    gchar label[255];
    g_snprintf(label, 255, _("Save project \"%s\" before leaving?"), last_project_filename);
    switch( sg_accept_dialog(label, 0) ) {
      case SG_BUTTON_YES:
        sg_menu_save(widget, menu, data);
      case SG_BUTTON_NO:
        break;
      case SG_BUTTON_CANCEL:
      case SG_BUTTON_CLOSE:
      default:
        return;
    }
  }
  sg_project_quit();
}

void
sg_menu_exit_init(SGplugin *plugin)
{
  create_pixmap(plugin, exit_small_xpm);
}

void
sg_menu_new_plot_2d(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGplot *plot = sg_plot_new_with_layer(sg_plugin_layer_get("layer_2d"),"");
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar name[200];
  g_snprintf(name, 200, _("Plot%02d"), app->last_plot+1);
  sg_plot_rename(plot, name);
  sg_application_add_plot(SG_APPLICATION(app), plot);
}

void
sg_menu_new_plot_2d_init(SGplugin *plugin)
{
  create_pixmap(plugin, new_2d_small_xpm);
}

void
sg_menu_new_plot_3d(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGplot *plot = sg_plot_new_with_layer(sg_plugin_layer_get("layer_3d"),"");
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar name[200];
  g_snprintf(name, 200, _("Plot%02d"), app->last_plot+1);
  sg_plot_rename(plot, name);
  sg_application_add_plot(SG_APPLICATION(app), plot);
}

void
sg_menu_new_plot_3d_init(SGplugin *plugin)
{
  create_pixmap(plugin, new_3d_small_xpm);
}

void
sg_menu_new_plot_polar(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGplot *plot = sg_plot_new_with_layer(sg_plugin_layer_get("layer_polar"),"");
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar name[200];
  g_snprintf(name, 200, _("Plot%02d"), app->last_plot+1);
  sg_plot_rename(plot, name);
  sg_application_add_plot(SG_APPLICATION(app), plot);
}

void
sg_menu_new_plot_polar_init(SGplugin *plugin)
{
  create_pixmap(plugin, new_polar_small_xpm);
}

void
sg_menu_new_worksheet(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGworksheet *worksheet = sg_worksheet_new("",20,5);
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar name[200];
  g_snprintf(name, 200, _("Data%02d"), app->last_worksheet+1);
  sg_worksheet_rename(worksheet, name);
  sg_application_add_worksheet(SG_APPLICATION(app), worksheet);
}

void
sg_menu_new_worksheet_init(SGplugin *plugin)
{
  create_pixmap(plugin, sheet_small_xpm);
}

void
sg_menu_new_matrix(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGmatrix *matrix = sg_matrix_new("",10,10);
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar name[200];
  g_snprintf(name, 200, _("Matrix%02d"), app->last_matrix+1);
  sg_worksheet_rename(SG_WORKSHEET(matrix), name);
  sg_application_add_matrix(SG_APPLICATION(app), SG_WORKSHEET(matrix));
}

void
sg_menu_new_matrix_init(SGplugin *plugin)
{
  create_pixmap(plugin, sheet_small_xpm);
}

/*
void
sg_menu_new_function(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  sg_function_dialog_new();
}
*/

void
sg_menu_new_project(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  gchar *last_path = NULL;

  if(sg_application_changed(SG_APPLICATION(app))){
    gchar label[80];
    g_snprintf(label, 80, _("Save project \"%s\" ?"), last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case SG_BUTTON_YES:
         sg_menu_save(widget, menu, data);
         break;
      case SG_BUTTON_NO:
         break;
      case SG_BUTTON_CANCEL:
      case SG_BUTTON_CLOSE:
      default:
         return;
    }
  }

  last_path = g_strdup(last_project_path);
  sg_project_close();
  sg_project_new(TRUE);
  sg_application_set_changed(SG_APPLICATION(app), FALSE);
  sg_project_set_path(last_path);
  g_free(last_path);
}

void
sg_menu_new_project_init(SGplugin *plugin)
{
  create_pixmap(plugin, new_small_xpm);
}

void
sg_menu_open(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  GtkWidget *dialog;
  gchar *last_path = NULL;
  gchar *last_filename = NULL;

  if(sg_application_changed(app)){
    gchar label[80];
    g_snprintf(label, 80, _("Save project \"%s\" ?"), last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case SG_BUTTON_YES:
         sg_menu_save(widget, menu, data);
         break;
      case SG_BUTTON_NO:
         break;
      case SG_BUTTON_CANCEL:
      case SG_BUTTON_CLOSE:
      default:
         return;
    }
  }

  last_path = g_strdup(last_project_path);
  last_filename = g_strdup(last_project_filename);
  sg_project_close();
  sg_project_new(FALSE);
  sg_application_set_path(app, last_path);
  sg_application_set_filename(app, last_filename);
  dialog = sg_file_dialog_new(SG_PLUGIN_FILE_OPEN, app, "project", G_OBJECT(app));
  sg_file_dialog_run(dialog);
  sg_application_set_changed(app, FALSE);
  sg_project_set_path(app->path);
  sg_project_set_filename(app->filename);
  sg_project_set_title();
  g_free(last_path);
  g_free(last_filename);
}

void
sg_menu_open_init(SGplugin *plugin)
{
  create_pixmap(plugin, open_small_xpm);
}

void
sg_menu_import(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  GtkWidget *dialog = NULL;
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));

  sg_application_set_path(app, last_project_path);
  sg_application_set_filename(app, last_project_filename);
  dialog = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, app, "project", G_OBJECT(app));
  sg_file_dialog_run(dialog);
  sg_project_set_path(app->path);
  sg_project_set_filename(app->filename);
  sg_project_set_title();
}

void
sg_menu_import_init(SGplugin *plugin)
{
  create_pixmap(plugin, open_small_xpm);
}


void
sg_menu_save(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGpluginFile *plugin = NULL;
  gchar *path;
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  GObject *object = G_OBJECT(app);
  plugin = sg_plugin_file_get("xml","project",SG_PLUGIN_FILE_SAVE);
  if(!plugin)
    plugin = sg_plugin_file_get("xml","project",SG_PLUGIN_FILE_EXPORT);
  if(!plugin)
    plugin = sg_plugin_file_get("xml","project",SG_PLUGIN_FILE_SAVE_AS);

  if(!plugin){
    g_warning("Failed to save file\n");
    return;
  }

  path = g_strconcat(last_project_path,G_DIR_SEPARATOR_S, last_project_filename, NULL);
  plugin->action(plugin, path, NULL, &object, NULL); 
  sg_application_set_changed(app, FALSE);

  g_free(path);
}

void
sg_menu_save_init(SGplugin *plugin)
{
  create_pixmap(plugin, save_small_xpm);
}

void
sg_menu_save_as(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  GtkWidget *dialog = NULL;
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));

  sg_application_set_path(app, last_project_path);
  sg_application_set_filename(app, last_project_filename);
  dialog = sg_file_dialog_new(SG_PLUGIN_FILE_SAVE, app, "project", G_OBJECT(app));
  sg_file_dialog_run(dialog);
  sg_application_set_changed(app, FALSE);
  sg_project_set_path(app->path);
  sg_project_set_filename(app->filename);
  sg_project_set_title();
}

void
sg_menu_save_as_init(SGplugin *plugin)
{
  create_pixmap(plugin, save_as_small_xpm);
}

void
sg_menu_preferences(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  sg_preferences_dialog();
}

void
sg_menu_preferences_init(SGplugin *plugin)
{
  create_pixmap(plugin, preferences_small_xpm);
}

void
sg_menu_python(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  sg_python_config_dialog();
}

void
sg_menu_python_init(SGplugin *plugin)
{
  create_pixmap(plugin, python_small_xpm);
}

void
sg_menu_about(GtkWidget *widget, GtkWidget *menu, gpointer data)
{
  SGapplication *app = SG_APPLICATION(g_object_get_data(G_OBJECT(menu), "application"));
  sg_about_dialog();
}

void
sg_menu_about_init(SGplugin *plugin)
{
  create_pixmap(plugin, about_small_xpm);
}

