/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include <scigraphica/sg_application.h>
#include "pixmaps/sg_small.xpm"

void
project_xml_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_SAVE;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".sg");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
project_xml_export (SGpluginFile *plugin, 
		    const gchar *filename, 
		    FILE *stream,
                    GObject **object, gpointer data)
{  
  GList *list;
  SGpluginFile *aux_plugin;
  SGapplication *app = SG_APPLICATION(*object);

  stream = sg_file_open(filename, "wb");
  if (!stream){
       g_warning( _("ERROR: Cannot write to file: %s"), filename);
       return FALSE;
  }
  sg_file_printf(stream, "<?xml version=\"1.0\"?>\n");
  sg_file_printf(stream, "<sg:Project xmlns:sg=\"http://scigraphica.sourceforge.net\">\n");
  sg_file_printf(stream, "  <sg:Doc version=\"2\" />\n");

  sg_file_printf(stream, "  <sg:Summary>\n");
  sg_file_printf(stream, "    <sg:Item>\n");
  sg_file_printf(stream, "      <sg:name>application</sg:name>\n");
  sg_file_printf(stream, "      <sg:val-string>scigraphica</sg:val-string>\n");
  sg_file_printf(stream, "    </sg:Item>\n");
  sg_file_printf(stream, "    <sg:Item>\n");
  sg_file_printf(stream, "      <sg:name>author</sg:name>\n");
  sg_file_printf(stream, "      <sg:val-string>%s</sg:val-string>\n", g_get_real_name());
  sg_file_printf(stream, "    </sg:Item>\n");
  sg_file_printf(stream, "  </sg:Summary>\n");

  list = app->worksheets->list;
  while(list){
    SGlistChild *child = (SGlistChild *)list->data;
    GObject *real_object = NULL;
    if(GTK_IS_SG_WORKSHEET_WINDOW(child->object))
      real_object = G_OBJECT(SG_WORKSHEET_WINDOW(child->object)->worksheet);
    else
      real_object = G_OBJECT(child->object);

    if(GTK_IS_SG_MATRIX(real_object))
      aux_plugin = sg_plugin_file_get("xml", "SGmatrix", SG_PLUGIN_FILE_EXPORT);
    else 
      aux_plugin = sg_plugin_file_get("xml", "SGworksheet", SG_PLUGIN_FILE_EXPORT);

    if(aux_plugin) aux_plugin->action(aux_plugin,filename,stream,&real_object,NULL);

    list = list->next;
  }

  list = app->datasets->list;
  while(list){
    SGlistChild *child = (SGlistChild *)list->data;
    GObject *real_object = G_OBJECT(child->object);

    aux_plugin = sg_plugin_file_get("xml", "sg_dataset", SG_PLUGIN_FILE_EXPORT);
    if(aux_plugin) aux_plugin->action(aux_plugin,filename,stream,&real_object,NULL);

    list = list->next;
  }

  list = app->plots->list;
  while(list){
    SGlistChild *child = (SGlistChild *)list->data;
    GObject *real_object = NULL;
    if(GTK_IS_SG_PLOT_WINDOW(child->object))
      real_object = G_OBJECT(SG_PLOT_WINDOW(child->object)->plot);
    else
      real_object = G_OBJECT(child->object);

    aux_plugin = sg_plugin_file_get("xml", "SGplot", SG_PLUGIN_FILE_EXPORT);
    if(aux_plugin) aux_plugin->action(aux_plugin,filename,stream,&real_object,NULL);

    list = list->next;
  }

  sg_file_printf(stream, "</sg:Project>\n");

  sg_file_close(stream);
  return TRUE;
}


