/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Copyright (C) 1985 - 1989 by Software Research Associates, Inc. */

#define	VERSION		"1.4"
#define	VERDATE		"Dec 5, 1985"
#ifndef	MAXDATA
#define	MAXDATA		400
#endif
#ifndef	SENDUSR
#define	SENDUSR		"kurihara@sra.co.jp"
#endif

#define	LEN_BUFF	160		/* Size of general buffer	     */
#define	LEN_FLWSCH	(LINES -  3)	/*	   full schedule window	     */
#define	LEN_HFWSCH	(LINES - 11)	/*         half schedule window	     */
#define	POS_MONTH	0		/* Column of month in schedule file  */
#define	POS_DAY		3		/*	     day		     */
#define	POS_START	7		/*	     start time		     */
#define	POS_END		13		/*	     end time		     */
#define	POS_WORK	19		/*	     work time		     */
#define	POS_PRJ		31		/*	     project code	     */
#define	POS_MSG		35		/*	     message		     */
#define	SCR_DAY		0		/* Column of month/day in screen     */
#define	SCR_EDAY	4		/*	     end of month/day	     */
#define	SCR_BAR		6		/*	     time		     */
#if 0
#define	SCR_WORK	32		/*	     work time		     */
#define	SCR_PRJ		44		/*	     project code	     */
#define	SCR_MSG		48		/*	     message		     */
#else
#define	SCR_WORK	(6 + (dayend - daystart + 1) * hourwidth)		/*	     work time		     */
#define	SCR_PRJ		(6 + 12 + (dayend - daystart + 1) * hourwidth)		/*	     project code	     */
#define	SCR_MSG		(6 + 12 + 4 + (dayend - daystart + 1) * hourwidth)		/*	     message		     */
#endif
#define	FLD_DAY		1		/* Field # of day in screen	     */
#define	FLD_WORK	2		/*	      work time		     */
#define	FLD_PRJ		3		/*	      project code	     */
#define	FLD_MSG		4		/*	      message		     */
#define	ERS_CHAR	'\010'		/* Erase key for character	     */
#define	ERS_WORD	'\027'		/*		 word		     */
#define	ERS_LINE	'\025'		/*		 line		     */
#define	ESCAPE		'\033'		/* Character ESC		     */
#define	SPACE		' '		/* 	     SPACE		     */
#define	TAB		'\t'		/* 	     TAB		     */
#define	BELL		'\007'		/* 	     BELL		     */
#define	CMD_SJCHAR	'j'		/*	       cursor down	     */
#define	CMD_SKCHAR	'k'		/*	       cursor up	     */
#define	CMD_SLCHAR	'l'		/*	       cursor right	     */
#define	CMD_SHCHAR	'h'		/*	       cursor left	     */
#define	CMD_RTCHAR	' '		/*	       next character	     */
#define	CMD_HLINE	'0'		/*	       head of line	     */
#define	CMD_ELINE	'$'		/*	       end of line	     */
#define	CMD_HEAD	'H'		/*	       head of screen	     */
#define	CMD_MIDDLE	'M'		/*	       middle of screen	     */
#define	CMD_BOTTOM	'L'		/*	       bottom of screen	     */
#define	CMD_LFCHAR	'\010'		/*	       previous character    */
#define	CMD_NXCHAR	'\t'		/*	       next field	     */
#define	CMD_REPLACE	'r'		/*	       change massage	     */
#define	CMD_INSERT	'i'		/*	       insert massage	     */
#define	CMD_APPEND	'a'		/*	       append massage	     */
#define	CMD_ALLREP	'R'		/*	       reset all message     */
#define	CMD_SORT	's'		/*	       sort		     */
#define	CMD_SENDBUG	'S'		/*	       send bug		     */
#define	CMD_YANK	'y'		/*	       yanc line	     */
#define	CMD_PRYANK	'Y'		/*	       print yanced line     */
#define	CMD_LNPUT	'p'		/*	       put line		     */
#define	CMD_PUT		'P'		/*	       put field	     */
#define	CMD_MARK	'm'		/*	       mark line	     */
#define	CMD_GENERATE	'g'		/*	       generate blank line   */
#define	CMD_GOTO	'G'		/*	       goto line	     */
#define	CMD_HELP	'@'		/*	       help		     */
#define	CMD_HARDCOPY	'='		/*	       hard copy	     */
#define	CMD_VERSION	'\026'		/*	       show version	     */
#define	CMD_STATUS	'\007'		/*	       show status	     */
#define	UPD_LFCHAR	'\010'		/* Command for previous character    */
#define	UPD_RTCHAR	'\014'		/*	       next character	     */
#define	UPD_LFWORD	'\002'		/*	       previous word	     */
#define	UPD_RTWORD	'\006'		/*	       next word	     */
#define	UPD_EOLDEL	'\005'		/*	       erase to EOL	     */
#define	UPD_WRDDEL	'\027'		/*	       erase word	     */
#define	UPD_1DELCHR	'\003'		/*	       erase character	     */
#define	UPD_2DELCHR	'\001'		/*	       erase character	     */
#define	UPD_UNDO	'\025'		/*	       undo all		     */
#define	UPD_INSERT	'\016'		/*	       mode change	     */
#define	UPD_NXEXIT	'\n'		/*	       exit update mode	     */
#define	UPD_EXIT	'\033'		/*	       exit update mode	     */
#define HLP_LINES	8
#define	HLP_PNEXT	-1		/* Help next page		     */
#define	HLP_PHEAD	0		/*	summary			     */
#define	HLP_PCURS	1		/*	cursor motion		     */
#define	HLP_PSCRL	2		/*	window scroll		     */
#define	HLP_PSRCH	2		/*	search			     */
#define	HLP_PUPDT	3		/*	update			     */
#define	HLP_POTHR	4		/*	other			     */
#define	HLP_SCURS	'c'		/* Help cursor motion selection	     */
#define	HLP_SSCRL	'w'		/*	window scroll		     */
#define	HLP_SSRCH	's'		/*	search			     */
#define	HLP_SUPDT	'u'		/*	update			     */
#define	HLP_SOTHR	'o'		/*	other			     */
#define	SRCH_FOR	1		/* Search direction forward	     */
#define	SRCH_BACK	-1		/*		    backward	     */
#define	BAR_HELP "Command: cursor right SPACE,  cursor left ^H ^W ^U,  exit ESC"
#define	UPD_HELP "Command: cursor ^H ^L ^B ^F, erase ^C ^W ^E, undo ^U, mode ^N"
