# Towers of Hanoi in bash
# Generates a rotation.schedule file for SaraB
#
# Originally by Chet Ramey (chet@po.cwru.edu)
# Modified by Tristan Rhodes (tristanbob@hotmail.com)

#!/bin/bash

# Recursive function
hanoi() # n from to spare
{
    typeset -i nm1=$1-1
    ((nm1>0)) && hanoi $nm1 $2 $4 $3
    echo $1
    ((nm1>0)) && hanoi $nm1 $4 $3 $2
}

main()
{
    hanoi $1 1 2 3
}


# Test the input, must be between 3 to 9
case $1 in
[3-9])
    main $1 > temp_toh_data;;
*)  echo "${0##*/}: Argument must be from 3 to 9"
    exit 1;;
esac

# Count the number of lines in the file, then reduce by one
lines=`cat temp_toh_data | wc -l`
lines=`expr $lines - 1`

# Reduce the actual file by one line
head -n $lines temp_toh_data > temp_toh_data2

# Convert from numbers to letters
cat temp_toh_data2 | tr 123456789 ABCDEFGHI

# Delete temp files
rm temp_toh_data
rm temp_toh_data2

exit 0
