#!/bin/sh
#
# @(#)logroll.sh,v 1.10 2004/04/23 06:14:31 kim Exp
#
# Invokes the generic log roller/archiver on lots of logs.  The real
# work is done by roller, and the scripts in the logproc directory.
#
# 1996-07-28  Kimmo Suominen
#
PATH=@BINDIR@:@PREFIX@/bin:/bin:/usr/bin:/usr/sbin
export PATH

t=/tmp/LoGrOlL.$$
rm -f $t

defdir=/var/log
piddir=/var/run

logdir=
procdir=
roll=yes

usage="Usage: $0 [-n] [-d defaultdir] [-l logdir] [-p procdir] [-r piddir]"
while getopts d:l:np:r: opt
do
    case "$opt" in
    d)	defdir="$OPTARG";;
    l)	logdir="-l $OPTARG";;
    n)	roll=no;;
    p)	procdir="-p $OPTARG";;
    r)	piddir="$OPTARG";;
    *)	echo "$usage" >&2; exit 1;;
    esac
done
shift `expr $OPTIND - 1`
case $# in
0)  ;;
*)  echo "$usage" >&2; exit 1;;
esac

allfiles () {
    for syslogpid in syslogd.pid syslog.pid
    do
	if [ -f $piddir/$syslogpid ]
	then
	    break
	fi
    done
    grep -v '^#' <<!EOF
#
# Syntax notes:
# - use "none" for no pid file
# - only list the pid file once at the last entry for a daemon with
#   multiple log files (e.g. HTTP servers)
# - one could use "nobody" as the mailee if output is not desired
#
# Web server
#
# The trick here is to list the pid file for Apache on the error
# log.  The Juno proprietary HTTP server does not need a HUP, and
# it only creates an access log (errors are in the same log).
#
httpd-access	-	none		logs-www	TOP 10 Web Pages
httpd-ssl	-	none		logs-www	Web SSL event log
httpd-errors	HUP	httpd.pid	logs-www	Web error log
#
# Squid web proxy and cache
#
# At least the access log is recorded, so we list it last with
# the pid file.
#
squid-cache	-	none		logs-www	Squid cache log
squid-store	-	none		logs-www	Squid store log
squid-access	USR1	squid.pid	logs-www	Squid access log
#
# Single log files
#
aculog		-	none		logs-uucp	Caller log
cddb		-	none		logs-system	CDDB service log
kerberos.log	-	none		logs-system	Kerberos log
newstally	-	none		logs-news	News tally
procmail-mailman -	none		logs-mail	Mailman procmail filter
sendmail.st	-	none		logs-system	Sendmail statistics
xdm-errors	HUP	xdm.pid		logs-system	XDM service log
xferlog		-	none		logs-ftp	FTP transfer log
#
# Cron log on SVR4/Solaris.
# /etc/cron.d/logchecker does not signal any daemon.
# Most BSD systems use syslog for this (see below).
#
# NOTE: No other logfile can be called "log" now!
#
/var/cron/log	-	none		logs-system	Cron log
#
# Flexlm logs are rolled at boot because the flexlm daemon can't be
# convinced to close/reopen its logfiles.
#
# Files written by syslogd.  Most things should just go to "messages".
#
cron		-	none		logs-system	Cron log
ftp		-	none		logs-ftp	FTP service log
ipmon		-	none		logs-system	IP monitor log
maillog		-	none		logs-mail	Mail statistics
news		-	none		logs-news	NNTP service log
radius		-	none		logs-system	Ascend statistics
#
# Files written by miscellaneous processes -- not kept open.
#
wtmp		-	none		logs-system	User statistics
wtmpx		-	none		logs-system	User statistics
#
# Last, signal syslog to switch files
#
messages	HUP	$syslogpid	logs-system	System log
!EOF
}

allfiles |
while read logfile signame pidfile extras
do
    case $logfile in
    /*)	;;
    *)	logfile=$defdir/$logfile;;
    esac
    #
    # We must process even empty files to get signaling to the daemons.
    #
    if [ -f $logfile ]
    then
	if [ x$pidfile != xnone ]
	then
	    case $pidfile in
	    /*)	;;
	    *)	pidfile=$piddir/$pidfile;;
	    esac
	    if [ ! -f $pidfile ]
	    then
		echo "Warning: no pidfile $pidfile for logfile $logfile" >&2
		pidfile=none
	    fi
	fi
	echo "$logfile $signame $pidfile $extras" >> $t
    fi
done

if [ "$roll" = "yes" ]
then
    roller $logdir $procdir $t
else
    echo "[roller $logdir $procdir $t]"
    cat $t
fi
rm -f $t
