/*
 * kpbind.c
 *
 * Manipulate kpdev bindings
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_drive_types.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_pdev.h>
#include <nasd/nasd_getopt.h>

char *progname;

char *nasd_devname = "/dev/nasdkp0";

#define DO_NOTHING 0
#define DO_UNBIND  1

int doit = DO_NOTHING;

void
usage()
{
  fprintf(stderr, "USAGE: %s [options]\n", progname);
  fprintf(stderr, "  -d  devname\n");
  fprintf(stderr, "  -u  unbind\n");
  exit(1);
}

int
main(
  int     argc,
  char  **argv)
{
  NASDPD_unbind_t kpunbind;
  int fd, rc;
  char c;

  progname = argv[0];

  while (nasd_getopt(argc, argv, "d:u", &c)) {
    switch(c) {
      case 'u':
        doit = DO_UNBIND;
        break;
      case 'd':
        nasd_devname = nasd_optarg;
        break;
      default:
        fprintf(stderr, "Unknown option '%c'\n", nasd_optopt);
        usage();
    }
  }

  if (nasd_optind < argc)
    usage();

  fd = open(nasd_devname, O_RDWR);
  if (fd < 0) {
    perror("open");
    fprintf(stderr, "ERROR: could not open %s\n", nasd_devname);
    exit(1);
  }

  if (doit == DO_UNBIND) {
    rc = ioctl(fd, NASDPD_PUNBIND, &kpunbind);
    if (rc) {
      perror("NASDPD_PUNBIND");
      exit(1);
    }
    if (kpunbind.unbind_status) {
      fprintf(stderr, "ERROR: got nasd status 0x%x unbinding\n",
        kpunbind.unbind_status);
      exit(1);
    }
  }

  rc = close(fd);
  if (rc) {
    perror("close");
    exit(1);
  }

  exit(0);
}
