/*
 * nasd_rpcgen_c.h
 *
 * Included in C files generated by nasd_rpcgen
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_RPCGEN_C__H_
#define _NASD__NASD_RPCGEN_C__H_

/* will probably need to add "signed" keyword for AIX */

#ifdef DEC_OSF
#define NASD_CPP_LOC "/lib/cpp"
typedef           char   nasd_rpcgen_int8;
typedef  unsigned char   nasd_rpcgen_uint8;
typedef           short  nasd_rpcgen_int16;
typedef  unsigned short  nasd_rpcgen_uint16;
typedef           int    nasd_rpcgen_int32;
typedef  unsigned int    nasd_rpcgen_uint32;
typedef           long   nasd_rpcgen_int64;
typedef  unsigned long   nasd_rpcgen_uint64;
#endif /* DEC_OSF */

#ifdef __linux__
#define NASD_CPP_LOC "/lib/cpp"
typedef           char       nasd_rpcgen_int8;
typedef  unsigned char       nasd_rpcgen_uint8;
typedef           short      nasd_rpcgen_int16;
typedef  unsigned short      nasd_rpcgen_uint16;
typedef           int        nasd_rpcgen_int32;
typedef  unsigned int        nasd_rpcgen_uint32;
typedef           long long  usitll;
typedef  unsigned long long  unusitll;
typedef              usitll  nasd_rpcgen_int64;
typedef            unusitll  nasd_rpcgen_uint64;
#endif /* __linux__ */

#ifdef IRIX
#define NASD_CPP_LOC "/lib/cpp"
typedef    signed char       nasd_rpcgen_int8;
typedef  unsigned char       nasd_rpcgen_uint8;
typedef           short      nasd_rpcgen_int16;
typedef  unsigned short      nasd_rpcgen_uint16;
typedef           int        nasd_rpcgen_int32;
typedef  unsigned int        nasd_rpcgen_uint32;
#if (_MIPS_SZLONG == 64)
typedef               long   nasd_rpcgen_int64;
typedef      unsigned long   nasd_rpcgen_uint64;
#else /* (_MIPS_SZLONG == 64) */
typedef           long long  usitll;
typedef  unsigned long long  unusitll;
typedef              usitll  nasd_rpcgen_int64;
typedef            unusitll  nasd_rpcgen_uint64;
#endif /* (_MIPS_SZLONG == 64) */
#endif /* IRIX */

#ifdef SOLARIS
#define NASD_CPP_LOC "/usr/ccs/lib/cpp"
typedef           char       nasd_rpcgen_int8;
typedef  unsigned char       nasd_rpcgen_uint8;
typedef           short      nasd_rpcgen_int16;
typedef  unsigned short      nasd_rpcgen_uint16;
typedef           int        nasd_rpcgen_int32;
typedef  unsigned int        nasd_rpcgen_uint32;
typedef           long long  usitll;
typedef  unsigned long long  unusitll;
typedef              usitll  nasd_rpcgen_int64;
typedef            unusitll  nasd_rpcgen_uint64;
#endif /* SOLARIS */

#ifdef FREEBSD
#define NASD_CPP_LOC "/usr/bin/cpp"
typedef           char       nasd_rpcgen_int8;
typedef  unsigned char       nasd_rpcgen_uint8;
typedef           short      nasd_rpcgen_int16;
typedef  unsigned short      nasd_rpcgen_uint16;
typedef           int        nasd_rpcgen_int32;
typedef  unsigned int        nasd_rpcgen_uint32; 
typedef           long long  usitll;
typedef  unsigned long long  unusitll;
typedef              usitll  nasd_rpcgen_int64;
typedef            unusitll  nasd_rpcgen_uint64;
#endif /* FREEBSD */ 


#ifndef _NASD_SRPC_GENTYPE_DEFINED
typedef void *nasd_srpc_handle_t;
typedef int nasd_srpc_status_t;
#endif /* !_NASD_SRPC_GENTYPE_DEFINED */


/*
 * !!! These values *must* match
 *  NASD_SRPC_OPSTAT_PIPE_IN
 *  NASD_SRPC_OPSTAT_PIPE_OUT
 */
#define NASD_RPCGEN_SRPC_OPSTAT_PIPE_IN  0x1
#define NASD_RPCGEN_SRPC_OPSTAT_PIPE_OUT 0x2

#endif /* !_NASD__NASD_RPCGEN_C__H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
