/*
 * nasd_pipe_shm.h
 *
 * Shared-memory byte pipe functions
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_PIPE_SHM_H_
#define _NASD_PIPE_SHM_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct nasd_shm_pipe_state_s	nasd_shm_pipe_state_t;

struct nasd_shm_pipe_state_s {
  int shmid;
  nasd_byte_t *orig_buf;
  nasd_byte_t *cur_buf;
  int orig_buf_len;
  int buf_len_remain;
};

nasd_status_t nasd_shmpipe_create(nasd_len_t len, int *out_shmid,
                                  nasd_rpc_status_t *status);
nasd_status_t nasd_shmpipe_setup(int shmid, nasd_len_t len, 
                                 nasd_shm_pipe_state_t *state);
nasd_status_t nasd_shmpipe_setup_cs(int shmid, nasd_byte_t **shmbuf,
                                    nasd_rpc_status_t *status);
nasd_status_t nasd_shmpipe_complete(nasd_byte_t *buf);
nasd_status_t nasd_shmpipe_complete_cs(int shmid, nasd_byte_t *buf,
                                       nasd_rpc_status_t *status);
nasd_status_t nasd_shmpipe_push(void *real_pipe,
                                void *buf,
                                nasd_len_t in_len,
                                nasd_byte_t *ign1,
                                nasd_byte_t *ign2,
                                int *ign3);
nasd_status_t nasd_shmpipe_pull(void *real_pipe,
                                void *buf,
                                nasd_len_t in_len,
                                nasd_len_t *out_lenp,
                                nasd_byte_t *ignored1,
                                int *ignored2,
                                void (*ignored3)(),
                                void *ignored4);

#endif /* !_NASD_PIPE_SHM_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
