/*
 * nasd_pdrive_client_dce.h
 *
 * defs/structs used by DCE clients of NASD drives
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_PDRIVE_CLIENT_DCE_H_
#define _NASD__NASD_PDRIVE_CLIENT_DCE_H_

#include <nasd/nasd_options.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE

#include <nasd/nasd_itypes.h>
#include <nasd/nasd_pdrive.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_drive_types.h>
#include <nasd/nasd_pdrive_client.h>

/*
 * must be >= dce_c_error_string_len (160)
 */
#if NASD_CL_ERROR_STRING_LEN < 160
#error NASD_CL_ERROR_STRING_LEN too small for DCE
#endif /* NASD_CL_ERROR_STRING_LEN < 160 */

typedef struct nasd_drive_handle_dce_s {
  rpc_binding_handle_t  h;
} nasd_drive_handle_dce_t;


/*
 * DCE pipe monkey magic
 */

extern nasd_status_t nasd_cl_dce_init(nasd_shutdown_list_t *sl);

extern void nasd_cl_fo_alloc(rpc_ss_pipe_state_t state,
  unsigned int bsize, nasd_byte_t **buf, unsigned int *bcount);

extern void nasd_cl_fr_push(rpc_ss_pipe_state_t *state,
  idl_char *buf, unsigned32 count);

extern void nasd_cl_fw_pull(rpc_ss_pipe_state_t *state,
  idl_char *buf, unsigned32 in_count, unsigned32 *out_countp);

extern void nasd_cl_p_fo_list_alloc(rpc_ss_pipe_state_t state,
  unsigned int bsize, nasd_byte_t **buf, unsigned int *bcount);

extern void nasd_cl_p_fr_list_push(rpc_ss_pipe_state_t *state,
  idl_char *buf, unsigned32 count);

/*
 * DCE-direct wrappers
 */

extern void nasd_cl_prpc_null_dr(nasd_drive_handle_t handle,
  nasd_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_sync_dr(nasd_drive_handle_t handle,
  nasd_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_part_creat_dr(nasd_drive_handle_t handle, 
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_part_creat_dr_args_t *args,
  nasd_p_part_creat_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_create_dr__otw_provided(
  nasd_drive_handle_t handle, nasd_key_t req_key,
  nasd_security_param_t *sec_param, nasd_capability_t *capability,
  nasd_p_create_dr_args_t *args, nasd_p_create_dr_res_t *res,
  nasd_cl_p_otw_buf_t *otw, error_status_t *status);

extern void nasd_cl_prpc_getattr_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_getattr_dr_args_t *args,
  nasd_p_getattr_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_range_read_dr(nasd_drive_handle_t h,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_smpl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastread_dr_res_t *res,
  error_status_t *status);

extern void nasd_cl_prpc_range_tread_dr(nasd_drive_handle_t h,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, int is_read2, nasd_p_thrtl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastread_dr_res_t *res,
  error_status_t *status);

extern void nasd_cl_prpc_range_write_dr(nasd_drive_handle_t h,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_smpl_op_dr_args_t *args,
  nasd_mem_list_t *memlist, nasd_p_fastwrite_dr_res_t *res,
  error_status_t *status);

extern void nasd_cl_prpc_setattr_dr__otw_provided(
  nasd_drive_handle_t handle, nasd_key_t req_key,
  nasd_security_param_t *sec_param, nasd_capability_t *capability,
  nasd_p_setattr_dr_args_t *args, nasd_p_setattr_dr_res_t *res,
  nasd_cl_p_otw_buf_t *otw, error_status_t *status);

extern void nasd_cl_prpc_flush_obj_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_flush_obj_dr_args_t *args, 
  nasd_p_flush_obj_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_eject_obj_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_eject_obj_dr_args_t *args, 
  nasd_p_eject_obj_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_remove_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_remove_dr_args_t *args,
  nasd_p_remove_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_initialize_dr(nasd_drive_handle_t handle,
  nasd_p_initialize_dr_args_t *args, nasd_p_initialize_dr_res_t *res,
  error_status_t *status);

extern void nasd_cl_prpc_strt_iread_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_strt_iread_dr_args_t *args,
  nasd_p_strt_iread_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_stop_iread_dr(nasd_drive_handle_t handle,
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_stop_iread_dr_args_t *args,
  nasd_p_stop_iread_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_rshutdown_dr(nasd_drive_handle_t handle, 
  nasd_key_t req_key, nasd_security_param_t *sec_param,
  nasd_capability_t *capability, nasd_p_rshutdown_dr_args_t *args,
  nasd_p_rshutdown_dr_res_t *res, error_status_t *status);

extern void nasd_cl_prpc_getinfo_dr(nasd_drive_handle_t handle,
  nasd_p_getinfo_dr_res_t *res, error_status_t *status);

extern void nasd_cl_p_dce_register(int counter_lock_held);

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#endif /* !_NASD__NASD_PDRIVE_CLIENT_DCE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
