/*
 * nasd_pdev.h
 *
 * pseudo-device for performing nasd operations in the kernel on
 * behalf of a user-process
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_KPDEV_NASD_KPDEV_H_
#define _NASD_KPDEV_NASD_KPDEV_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_sys.h>


/* You might be wondering: Why are some arguments passed as pointers
and others as structs?  Some OSes (notably DUX3.2) have a too-small
limit on maximum size of an ioctl argument.   */

typedef struct NASDPD_bind_s {
  char           drive_name[256];
  char           drive_port[256];
  int            binding_type;
  caddr_t        binding_param;
  int            binding_param_len;
  nasd_status_t  bind_status;
} NASDPD_bind_t;

typedef struct NASDPD_unbind_s {
  nasd_status_t  unbind_status;
} NASDPD_unbind_t;

typedef struct NASDPD_null_s {
  nasd_status_t       nasd_status;
  nasd_rpc_status_t   op_status;
} NASDPD_null_t;

typedef struct NASDPD_sync_s {
  nasd_status_t      nasd_status;
  nasd_rpc_status_t  op_status;
} NASDPD_sync_t;

typedef struct NASDPD_p_crpart_s {
  nasd_key_t                   in_key;
  nasd_security_param_t        sec_param;
  nasd_capability_t            capability;
  int                          capability_valid;
  nasd_p_part_creat_dr_args_t  args;
  nasd_p_part_creat_dr_res_t   res;
  nasd_rpc_status_t            op_status;
} NASDPD_p_crpart_t;

typedef struct NASDPD_p_create_s {
  nasd_key_t                in_key;
  nasd_security_param_t     sec_param;
  nasd_capability_t         capability;
  int                       capability_valid;
  nasd_p_create_dr_args_t  *args;
  nasd_p_create_dr_res_t   *res;
  nasd_rpc_status_t         op_status;
} NASDPD_p_create_t;

typedef struct NASDPD_p_getattr_s {
  nasd_key_t                 in_key;
  nasd_security_param_t      sec_param;
  nasd_capability_t          capability;
  int                        capability_valid;
  nasd_p_getattr_dr_args_t  *args;
  nasd_p_getattr_dr_res_t   *res;
  nasd_rpc_status_t          op_status;
} NASDPD_p_getattr_t;

typedef struct NASDPD_p_write_simple_s {
  nasd_key_t                  in_key;
  nasd_security_param_t       sec_param;
  nasd_capability_t           capability;
  int                         capability_valid;
  void                       *buf;
  nasd_p_smpl_op_dr_args_t    args;
  nasd_p_fastwrite_dr_res_t   res;
  nasd_rpc_status_t           op_status;
} NASDPD_p_write_simple_t;

typedef struct NASDPD_p_read_simple_s {
  nasd_key_t                 in_key;
  nasd_security_param_t      sec_param;
  nasd_capability_t          capability;
  int                        capability_valid;
  int                        is_read2;
  void                      *buf;
  nasd_p_smpl_op_dr_args_t   args;
  nasd_p_fastread_dr_res_t   res;
  nasd_rpc_status_t          op_status;
} NASDPD_p_read_simple_t;

typedef struct NASDPD_p_tread_simple_s {
  nasd_key_t                  in_key;
  nasd_security_param_t       sec_param;
  nasd_capability_t           capability;
  int                         capability_valid;
  int                         is_read2;
  void                       *buf;
  nasd_p_thrtl_op_dr_args_t   args;
  nasd_p_fastread_dr_res_t    res;
  nasd_rpc_status_t           op_status;
} NASDPD_p_tread_simple_t;

typedef struct NASDPD_p_setattr_s {
  nasd_key_t                 in_key;
  nasd_security_param_t      sec_param;
  nasd_capability_t          capability;
  int                        capability_valid;
  nasd_p_setattr_dr_args_t  *args;
  nasd_p_setattr_dr_res_t   *res;
  nasd_rpc_status_t          op_status;
} NASDPD_p_setattr_t;

typedef struct NASDPD_p_flush_obj_s {
  nasd_key_t                  in_key;
  nasd_security_param_t       sec_param;
  nasd_capability_t           capability;
  int                         capability_valid;
  nasd_p_flush_obj_dr_args_t  args;
  nasd_p_flush_obj_dr_res_t   res;
  nasd_rpc_status_t           op_status;
} NASDPD_p_flush_obj_t;

typedef struct NASDPD_p_eject_obj_s {
  nasd_key_t                  in_key;
  nasd_security_param_t       sec_param;
  nasd_capability_t           capability;
  int                         capability_valid;
  nasd_p_eject_obj_dr_args_t  args;
  nasd_p_eject_obj_dr_res_t   res;
  nasd_rpc_status_t           op_status;
} NASDPD_p_eject_obj_t;

typedef struct NASDPD_p_remove_s {
  nasd_key_t               in_key;
  nasd_security_param_t    sec_param;
  nasd_capability_t        capability;
  int                      capability_valid;
  nasd_p_remove_dr_args_t  args;
  nasd_p_remove_dr_res_t   res;
  nasd_rpc_status_t        op_status;
} NASDPD_p_remove_t;

typedef struct NASDPD_p_initialize_s {
  nasd_p_initialize_dr_args_t  args;
  nasd_p_initialize_dr_res_t   res;
  nasd_rpc_status_t            op_status;
} NASDPD_p_initialize_t;

typedef struct NASDPD_p_strt_iread_s {
  nasd_key_t                   in_key;
  nasd_security_param_t        sec_param;
  nasd_capability_t            capability;
  int                          capability_valid;
  nasd_p_strt_iread_dr_args_t  args;
  nasd_p_strt_iread_dr_res_t   res;
  nasd_rpc_status_t            op_status;
} NASDPD_p_strt_iread_t;

typedef struct NASDPD_p_stop_iread_s {
  nasd_key_t                   in_key;
  nasd_security_param_t        sec_param;
  nasd_capability_t            capability;
  int                          capability_valid;
  nasd_p_stop_iread_dr_args_t  args;
  nasd_p_stop_iread_dr_res_t   res;
  nasd_rpc_status_t            op_status;
} NASDPD_p_stop_iread_t;

typedef struct NASDPD_p_rshutdown_s {
  nasd_key_t                  in_key;
  nasd_security_param_t       sec_param;
  nasd_capability_t           capability;
  int                         capability_valid;
  nasd_p_rshutdown_dr_args_t  args;
  nasd_p_rshutdown_dr_res_t   res;
  nasd_rpc_status_t           op_status;
} NASDPD_p_rshutdown_t;

typedef struct NASDPD_p_getinfo_s {
  nasd_p_getinfo_dr_res_t  res;
  nasd_rpc_status_t        op_status;
} NASDPD_p_getinfo_t;


typedef struct NASDPD_p_remote_attach_s {
  nasd_key_t                     in_key;
  nasd_security_param_t          sec_param;
  nasd_capability_t              capability;
  int                            capability_valid;
  void                           *buf;
  nasd_p_remote_attach_dr_args_t *args;
  nasd_p_remote_attach_dr_res_t  res;
  nasd_rpc_status_t              op_status;
} NASDPD_p_remote_attach_t;


typedef struct NASDPD_p_remote_detach_s {
  nasd_key_t                 in_key;
  nasd_security_param_t      sec_param;
  nasd_capability_t          capability;
  int                        capability_valid;
  nasd_p_remote_detach_dr_args_t   args;
  nasd_p_remote_detach_dr_res_t    res;
  nasd_rpc_status_t          op_status;
} NASDPD_p_remote_detach_t;


typedef struct NASDPD_p_remote_invoke_s {
  nasd_key_t                     in_key;
  nasd_security_param_t          sec_param;
  nasd_capability_t              capability;
  int                            capability_valid;
  void                           *buf;
  nasd_p_smpl_op_dr_args_t       args;
  nasd_p_fastread_dr_res_t       res;
  nasd_rpc_status_t              op_status;
} NASDPD_p_remote_invoke_t;



#define NASDPD_GET_OPENCOUNT    _IOR('N', 1, int)

#define NASDPD_PBIND        _IOWR('N', 20, NASDPD_bind_t)
#define NASDPD_PUNBIND      _IOWR('N', 21, NASDPD_unbind_t)

#define NASDPD_PNULL        _IOWR('N', 25, NASDPD_null_t)
#define NASDPD_PSYNC        _IOWR('N', 26, NASDPD_sync_t)

#define NASDPD_P_PCRPART        _IOWR('N', 50, NASDPD_p_crpart_t)
#define NASDPD_P_PCREATE        _IOWR('N', 51, NASDPD_p_create_t)
#define NASDPD_P_PGETATTR       _IOWR('N', 52, NASDPD_p_getattr_t)
#define NASDPD_P_PWRITE_SIMPLE  _IOWR('N', 53, NASDPD_p_write_simple_t)
#define NASDPD_P_PREAD_SIMPLE   _IOWR('N', 54, NASDPD_p_read_simple_t)
#define NASDPD_P_PTREAD_SIMPLE  _IOWR('N', 55, NASDPD_p_tread_simple_t)
#define NASDPD_P_PSETATTR       _IOWR('N', 56, NASDPD_p_setattr_t)
#define NASDPD_P_PFLUSH_OBJ     _IOWR('N', 57, NASDPD_p_flush_obj_t)
#define NASDPD_P_PREMOVE        _IOWR('N', 58, NASDPD_p_remove_t)
#define NASDPD_P_PINITIALIZE    _IOWR('N', 59, NASDPD_p_initialize_t)
#define NASDPD_P_PEJECT_OBJ     _IOWR('N', 60, NASDPD_p_eject_obj_t)
#define NASDPD_P_PWRITE_FAKE    _IOWR('N', 61, NASDPD_p_write_simple_t)
#define NASDPD_P_PREAD_FAKE     _IOWR('N', 62, NASDPD_p_read_simple_t)
#define NASDPD_P_PSTRT_IREAD    _IOWR('N', 63, NASDPD_p_strt_iread_t)
#define NASDPD_P_PSTOP_IREAD    _IOWR('N', 63, NASDPD_p_stop_iread_t)
#define NASDPD_P_PRSHUTDOWN     _IOWR('N', 64, NASDPD_p_rshutdown_t)
#define NASDPD_P_PGETINFO       _IOWR('N', 65, NASDPD_p_getinfo_t)
#define NASDPD_P_PREMOTE_ATTACH _IOWR('N', 66, NASDPD_p_remote_attach_t)
#define NASDPD_P_PREMOTE_DETACH _IOWR('N', 67, NASDPD_p_remote_detach_t)
#define NASDPD_P_PREMOTE_INVOKE _IOWR('N', 68, NASDPD_p_remote_invoke_t)

/* ioctls 'N'-80 and up are used in EDRFS */

#ifdef KERNEL
typedef struct NASDpd_s   NASDpd_t;

struct NASDpd_s {
  int                   state;
  nasd_drive_handle_t   h;
  int                   open_count;
};

extern NASDpd_t NASDPDs[NASD_NUM_KPDEV];

#define NASDPD_CLI_GETDEV(_dev_,_npd_,_unit_) { \
  _unit_ = nasdpd_unit(dev); \
  if (((_unit_) < 0) || ((_unit_) >= NASD_NUM_KPDEV)) { \
    _npd_ = NULL; \
  } \
  else { \
    _npd_ = &NASDPDs[_unit_]; \
  } \
}

#define NPD_STATE_BOGUS   0
#define NPD_STATE_BOUND   1
#define NPD_STATE_UNBOUND 2

#define NPD_MAXLOOPS 5

extern int nasdpd_do_fake_byte_ops;

#ifdef DEC_OSF
#define nasdpd_unit(_x_) minor(_x_)
#endif /* DEC_OSF */

#ifdef LINUX
#define nasdpd_unit(_x_) MINOR(_x_)
#endif /* LINUX */

extern nasd_status_t nasdpd_init(void);

extern int nasdpd_real_open(NASDpd_t *npd);
extern int nasdpd_real_close(NASDpd_t *npd);
extern int nasdpd_real_ioctl(NASDpd_t *npd, int cmd, caddr_t data);

#endif /* KERNEL */

#endif /* !_NASD_KPDEV_NASD_KPDEV_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
