/*
 * nasd_idl_types.h
 *
 * Author: Erik Riedel
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


/*
 * these MUST match the actual IDL types or the automatically generated
 * marshalling code will be incorrect
 * 
 */

#ifndef _NASD__NASD_IDL_TYPES_H_
#define _NASD__NASD_IDL_TYPES_H_

#if (defined(DEC) || defined(DEC_OSF)) && !defined(WIN32)

#define ndr_boolean        unsigned char
#define ndr_false          false
#define ndr_true           true
#define ndr_byte           unsigned char
#define ndr_char           unsigned char
#define ndr_int            int
#define ndr_uint           unsigned int
#define ndr_small_int      signed char
#define ndr_short_int      short int
#define ndr_long_int       int
#define ndr_usmall_int     unsigned char
#define ndr_ushort_int     unsigned short int
#define ndr_ulong_int      unsigned int
struct ndr_uhyper_int_rep   {ndr_ulong_int  low; ndr_ulong_int high;};
struct ndr_hyper_int_rep   {ndr_ulong_int low; ndr_long_int high;};
#ifdef __VMS
#define ndr_uhyper_int     unsigned __int64
#define ndr_hyper_int      signed __int64
#else
#define ndr_uhyper_int     unsigned long int
#define ndr_hyper_int      long int
#endif /* __VMS */

#else /* (DEC || DEC_OSF) && !WIN32 */

#if defined(sparc)

/* from /usr/include/dce/ndrtypes.h on Solaris 2.0 (Transarc DCE 2.1) */
 
typedef unsigned char           ndr_boolean ;
typedef unsigned char           ndr_byte ;
typedef unsigned char           ndr_char ;
typedef signed char             ndr_small_int ;
typedef unsigned char           ndr_usmall_int ;
typedef short int               ndr_short_int ;
typedef unsigned short int      ndr_ushort_int ;
typedef long int                ndr_long_int ;
typedef unsigned long int       ndr_ulong_int ;
struct ndr_hyper_int_rep_s_t {
    ndr_long_int high;
    ndr_ulong_int low;
};
typedef struct ndr_hyper_int_rep_s_t ndr_hyper_int ;
struct ndr_uhyper_int_rep_s_t  {
    ndr_ulong_int high;
    ndr_ulong_int low;
};
typedef struct ndr_uhyper_int_rep_s_t           ndr_uhyper_int ;

#else /* sparc */

#if defined(i386) || defined(LINUX_I386)

/* from /usr/pdl/include/dce/ndrtypes.h on Linux (Linux DCE 1.1) */

#if 0
typedef unsigned char 		ndr_boolean ;
#define ndr_false       false
#define ndr_true        true
typedef unsigned char 		ndr_byte ;
typedef unsigned char 		ndr_char ;
typedef signed char 		ndr_small_int ;
typedef unsigned char 		ndr_usmall_int ;
typedef short int 		ndr_short_int ;
typedef unsigned short int	ndr_ushort_int ;
typedef int 			ndr_long_int ;
typedef unsigned int 		ndr_ulong_int ;
struct ndr_hyper_int_rep_s_t {
    ndr_ulong_int low; 
    ndr_long_int high;
};
struct ndr_uhyper_int_rep_s_t  {
    ndr_ulong_int low; 
    ndr_ulong_int high;
};
typedef long long int		usitll;
typedef unsigned long long int	unusitll;
typedef usitll			ndr_hyper_int ;
typedef unusitll		ndr_uhyper_int ;
#else

#define ndr_boolean        unsigned char
#define ndr_false          false
#define ndr_true           true
#define ndr_byte           unsigned char
#define ndr_char           unsigned char
#define ndr_int            int
#define ndr_uint           unsigned int
#define ndr_small_int      signed char
#define ndr_short_int      short int
#define ndr_long_int       long
#define ndr_usmall_int     unsigned char
#define ndr_ushort_int     unsigned short int
#define ndr_ulong_int      unsigned long
struct ndr_uhyper_int_rep   {ndr_ulong_int  low; ndr_ulong_int high;};
struct ndr_hyper_int_rep   {ndr_ulong_int low; ndr_long_int high;};
#define ndr_uhyper_int     unusitll
#define ndr_hyper_int      usitll

#endif

#endif /* i386 || LINUX_I386 */
#endif /* sparc */
#endif /* (DEC || DEC_OSF) && !WIN32 */

typedef ndr_boolean             idl_boolean ;
typedef ndr_byte                idl_byte ;
typedef char                    idl_char ;
typedef ndr_small_int           idl_small_int ;
typedef ndr_usmall_int          idl_usmall_int ;
typedef ndr_short_int           idl_short_int ;
typedef ndr_ushort_int          idl_ushort_int ;
typedef ndr_long_int            idl_long_int ;
typedef ndr_ulong_int           idl_ulong_int ;
typedef ndr_hyper_int           idl_hyper_int ;
typedef ndr_uhyper_int          idl_uhyper_int ;
typedef ndr_ulong_int           idl_size_t;

#endif /* !_NASD__NASD_IDL_TYPES_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
