/*
 * nasd_general.h
 *
 * Common NASD defines
 *
 * Authors: Mark Holland, Daniel Stodolsky, Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1995,1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_GENERAL_H_
#define _NASD__NASD_GENERAL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_general_simple.h>
#include <nasd/nasd_types.h>

#define NASD_TRUE  1
#define NASD_FALSE 0

#define NASD_NSEC_PER_SEC 1000000000
#define NASD_USEC_PER_SEC 1000000
#define NASD_TIMESPEC_VALID(_ts_) (((_ts_).ts_sec >= 0) && ((_ts_).ts_nsec >= 0) && ((_ts_).ts_nsec < NASD_NSEC_PER_SEC))
#define NASD_TIMESPEC_VALID_NZ(_ts_) (((_ts_).ts_sec >= 0) && ((_ts_).ts_nsec >= 0) && ((_ts_).ts_nsec < NASD_NSEC_PER_SEC) && ((_ts_).ts_sec || (_ts_).ts_nsec))
#define NASD_TIMESPEC_EQ(_ts1_,_ts2_) (((_ts1_).ts_sec == (_ts2_).ts_sec) && ((_ts1_).ts_nsec == (_ts2_).ts_nsec))
#define NASD_TIMESPEC_GT(_ts1_,_ts2_) (((_ts1_).ts_sec > (_ts2_).ts_sec) || (((_ts1_).ts_sec == (_ts2_).ts_sec) && ((_ts1_).ts_nsec > (_ts2_).ts_nsec)))
#define NASD_TIMESPEC_LT(_ts1_,_ts2_) (((_ts1_).ts_sec < (_ts2_).ts_sec) || (((_ts1_).ts_sec == (_ts2_).ts_sec) && ((_ts1_).ts_nsec < (_ts2_).ts_nsec)))
#define NASD_TIMESPEC_GE(_ts1_,_ts2_) (((_ts1_).ts_sec > (_ts2_).ts_sec) || (((_ts1_).ts_sec == (_ts2_).ts_sec) && ((_ts1_).ts_nsec >= (_ts2_).ts_nsec)))
#define NASD_TIMESPEC_LE(_ts1_,_ts2_) (((_ts1_).ts_sec < (_ts2_).ts_sec) || (((_ts1_).ts_sec == (_ts2_).ts_sec) && ((_ts1_).ts_nsec <= (_ts2_).ts_nsec)))
#define NASD_TIMESPEC_SUB(_result_,_subtrahend_) { \
  if ((_result_).ts_nsec >= (_subtrahend_).ts_nsec) { \
    (_result_).ts_nsec -= (_subtrahend_).ts_nsec; \
    (_result_).ts_sec -= (_subtrahend_).ts_sec; \
  } \
  else { \
    (_result_).ts_nsec += NASD_NSEC_PER_SEC; \
    (_result_).ts_nsec -= (_subtrahend_).ts_nsec; \
    (_result_).ts_sec -= (_subtrahend_).ts_sec + 1; \
  } \
}
#define NASD_TIMESPEC_ADD(_result_,_addend_) { \
  (_result_).ts_nsec += (_addend_).ts_nsec; \
  (_result_).ts_sec += (_addend_).ts_sec; \
  if ((_result_).ts_nsec >= NASD_NSEC_PER_SEC) { \
    (_result_).ts_nsec -= NASD_NSEC_PER_SEC; \
    (_result_).ts_sec ++; \
  } \
}
#define NASD_TIMESPEC_ZERO(_ts_) { \
  (_ts_).ts_sec = 0; \
  (_ts_).ts_nsec = 0; \
}
#define NASD_TIMESPEC_EQ_ZERO(_ts_) (((_ts_).ts_sec == 0) && ((_ts_).ts_nsec == 0))

#define NASD_ID_CMP(_a_,_b_) ((_a_) - (_b_))
#define NASD_ID_EQ(_a_,_b_) ((_a_) == (_b_))

#define NASD_ATOMIC_TIMESPEC_ADD(_resultp_,_addendp_) \
  nasd_atomic_add_timespec(_resultp_,_addendp_)

#ifdef DEC_OSF
extern unsigned long nasd_atomic_add_timespec(
  nasd_timespec_t *result, nasd_timespec_t *addend);
#endif /* DEC_OSF */

#ifndef DEC_OSF
extern void nasd_atomic_add_timespec(nasd_timespec_t *result,
  nasd_timespec_t *addend);
#endif /* !DEC_OSF */

#if defined(DEC_OSF) && defined(KERNEL)

#define NASD_ATOMIC_INC64(_var_) atomic_incq((_var_))
#define NASD_ATOMIC_DEC64(_var_) atomic_decq((_var_))
#define NASD_ATOMIC_ADD64(_var_,_val_) atomic_addq((_var_),(_val_))
#define NASD_ATOMIC_SUB64(_var_,_val_) nasd_atomic_sub64((_var_),((nasd_int64)(_val_)))
extern void nasd_atomic_sub64(nasd_uint64 *, nasd_int64);

#else /* DEC_OSF && KERNEL */

#define NASD_ATOMIC_INC64(_var_) nasd_atomic_inc64((_var_))
#define NASD_ATOMIC_DEC64(_var_) nasd_atomic_add64((_var_), (nasd_int64)(-1))
#define NASD_ATOMIC_ADD64(_var_,_val_) nasd_atomic_add64((_var_),((nasd_int64)(_val_)))
#define NASD_ATOMIC_SUB64(_var_,_val_) nasd_atomic_sub64((_var_),((nasd_int64)(_val_)))

extern void nasd_atomic_inc64(nasd_uint64 *);
extern void nasd_atomic_add64(nasd_uint64 *, nasd_int64);
extern void nasd_atomic_sub64(nasd_uint64 *, nasd_int64);

#endif /* DEC_OSF && KERNEL */

#ifdef KERNEL
#ifndef NULL
#define NULL 0L
#endif /* !NULL */
#endif /* KERNEL */

#endif /* _NASD__NASD_GENERAL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
