/*
 * nasd_drive_utils.h
 *
 * Header for "drive utils" library
 * used by drive and support utilities.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DRIVE_UTILS_H_
#define _NASD__NASD_DRIVE_UTILS_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_drive_options.h>
#include <nasd/nasd_od.h>
#include <nasd/nasd_sys.h>

typedef struct nasd_drive_layout_basic_s  nasd_drive_layout_basic_t;

struct nasd_drive_layout_basic_s {
  nasd_sectno_t   header1_blk;
  nasd_sectno_t   header2_blk;
  nasd_blkcnt_t   num_blocks;
  nasd_sectno_t   last_data_sector;
  nasd_blkcnt_t   num_refblocks;
  nasd_sectcnt_t  firstblock_offset;
  nasd_sectcnt_t  firstref_offset;
  nasd_sectcnt_t  num_sectors;
};

extern nasd_status_t nasd_drive_compute_basic_layout(
  unsigned long               num_real_sectors,
  nasd_drive_layout_basic_t  *layoutp);

extern int nasd_od_force_align_disk_boundary;

#endif /* !_NASD__NASD_DRIVE_UTILS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
