/*
 * nasd_cheops_rpc.h
 *
 * External declarations and crud for Cheops
 */
/*
 * Author: Sean Levy
 *
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#ifndef _NASD_CHEOPS_RPC_H_
#define _NASD_CHEOPS_RPC_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_pipe.h>
#include <nasd/nasd_cheops_mgr_internal.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
# include <nasd/nasd_srpc.h>

typedef struct nasd_cheops_handle_srpc_s {
  nasd_srpc_handle_t	h;
} nasd_cheops_handle_srpc_t;

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE

typedef struct nasd_cheops_handle_dce_s {
  rpc_binding_handle_t  h;
} nasd_cheops_handle_dce_t;

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#endif /* !_NASD_CHEOPS_RPC_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
