/*
 * nasd_cheops_mgr_btree.h
 *
 * B-tree related definitions
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef  _NASD_CHEOPS_BTREE_H_
#define  _NASD_CHEOPS_BTREE_H_

#define D 6 
#define NULL_MFP NULL
#define MAX_BTREE_NODES 2000

#define FULL_NODE(t) ( t->d == 2*D )
typedef int nodeid_t;

typedef int typekey;
typedef int node_ptr_t;

typedef struct node_s {       
  int level;                  /* Level 0: leaf node                  */
  int nodeid;		      /* page id                             */
  int d;                      /* number of active entries            */
  typekey k[2*D+1];           /* Keys                                */
  node_ptr_t  p[2*D+2];       /* Pointers to children nodes          */
} node_t, *btree_t;

typedef struct keynode_pair_s {
 typekey key;
 node_ptr_t nodeid;
} keynode_pair_t; 

#endif /* _NASD_CHEOPS_BTREE_H_ */








