/*
 * nasd_cheops_locks.h
 *
 * Lock module header file, implements multi-reader single-writer locks
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_CHEOPS_LOCKS_H_
#define _NASD_CHEOPS_LOCKS_H_

#include <stdio.h>
#include <malloc.h>

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_threadstuff.h>

typedef struct _nasd_cheops_rwlock_s {
        NASD_DECLARE_MUTEX(m)
        NASD_DECLARE_COND(canRead)
        NASD_DECLARE_COND(canWrite)
        int  nActive;
        int  nPendingReaders;
        int  nPendingWriters;
} _nasd_cheops_rwlock_t;

int 
_nasd_cheops_lockInit( _nasd_cheops_rwlock_t *l );

int 
_nasd_cheops_lockShared( _nasd_cheops_rwlock_t *l );

int 
_nasd_cheops_unlockShared( _nasd_cheops_rwlock_t *l);

int 
_nasd_cheops_lockExclusive( _nasd_cheops_rwlock_t *l );

int 
_nasd_cheops_unlockExclusive( _nasd_cheops_rwlock_t *l );

int 
_nasd_cheops_downgrade( _nasd_cheops_rwlock_t *l );

int 
_nasd_cheops_upgrade( _nasd_cheops_rwlock_t *l );


#endif /* !_NASD_CHEOPS_LOCKS_H_ */


