/*
 * nasd_cheops_client.h
 *
 * Cheops client API (for talking to the cheops manager)
 */
/*
 * Copyright (c) 1998,1999 Carnegie-Mellon University.
 * All rights reserved.
 *
 * Authors: Sean Levy
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon the
 * rights to redistribute these changes.
 */

#ifndef _NASD__NASD_CHEOPS_CLIENT_H_
#define _NASD__NASD_CHEOPS_CLIENT_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_mgr.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct nasd_cheops_default_bindings_s  nasd_cheops_default_bindings_t;
typedef struct nasd_cheops_handle_s	       nasd_cheops_handle_s_t;
typedef struct nasd_cheops_handle_s            *nasd_cheops_handle_t;
typedef struct nasd_cheops_client_rpcmod_tab_s nasd_cheops_client_rpcmod_tab_t;

/*
 * init/shutdown
 */
nasd_status_t nasd_cheops_client_real_init(void);
void nasd_cheops_client_real_shutdown(void);
void nasd_cheops_client_sys_init(void);
nasd_status_t nasd_cheops_client_init(void);
void nasd_cheops_client_shutdown(void);

/*
 * Switch table types
 */

typedef nasd_status_t (*nasd_cheops_client_init_t)(
  nasd_shutdown_list_t  *sl);

typedef nasd_status_t (*nasd_cheops_client_bind_t)(
  nasd_cheops_handle_t  handle,
  char                 *server_name,
  char                 *portnum,
  int                   binding_type,
  void                 *binding_param,
  int                   binding_param_len);

typedef nasd_status_t (*nasd_cheops_client_unbind_t)(
  nasd_cheops_handle_t  handle);

typedef void (*nasd_cheops_client_null_t)(
  nasd_cheops_handle_t   handle,
  nasd_res_t           *res,
  nasd_rpc_status_t    *status);

typedef void (*nasd_cheops_client_bs_lookup_t)(
  nasd_cheops_handle_t       handle,
  nasd_cheops_bs_lu_args_t  *in_args,
  nasd_cheops_bs_lu_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

typedef void (*nasd_cheops_client_mgr_lookup_t)(
  nasd_cheops_handle_t        handle,
  nasd_cheops_mgr_lu_args_t  *in_args,
  nasd_cheops_mgr_lu_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_cheops_client_dr_lookup_t)(
  nasd_cheops_handle_t        handle,
  nasd_cheops_dr_lu_args_t  *in_args,
  nasd_cheops_dr_lu_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_cheops_client_bs_refresh_t)(
  nasd_cheops_handle_t        handle,
  nasd_cheops_bs_re_args_t  *in_args,
  nasd_cheops_bs_re_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_cheops_client_bs_qos_create_t)(
  nasd_cheops_handle_t         handle,
  nasd_cheops_bs_qc_args_t  *in_args,
  nasd_cheops_bs_qc_res_t   *out_res,
  nasd_rpc_status_t          *op_status);

typedef void (*nasd_cheops_client_bs_create_t)(
  nasd_cheops_handle_t        handle,
  nasd_cheops_bs_cr_args_t  *in_args,
  nasd_cheops_bs_cr_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_cheops_client_bs_remove_t)(
  nasd_cheops_handle_t         handle,
  nasd_cheops_bs_rm_args_t  *in_args,
  nasd_cheops_bs_rm_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

typedef void (*nasd_cheops_client_bs_getattr_t)(
  nasd_cheops_handle_t         handle,
  nasd_cheops_bs_ga_args_t  *in_args,
  nads_cheops_bs_ga_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

typedef void (*nasd_cheops_client_bs_setattr_t)(
  nasd_cheops_handle_t         handle,
  nasd_cheops_bs_sa_args_t  *in_args,
  nads_cheops_bs_sa_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

struct nasd_cheops_client_rpcmod_tab_s {
  nasd_cheops_client_init_t             init;
  nasd_status_t                         init_status;

  nasd_cheops_client_bind_t             bind;
  nasd_cheops_client_unbind_t           unbind;

  nasd_cheops_client_null_t             null;
  nasd_cheops_client_bs_lookup_t        bs_lookup;
  nasd_cheops_client_mgr_lookup_t       mgr_lookup;
  nasd_cheops_client_dr_lookup_t        dr_lookup;
  nasd_cheops_client_bs_refresh_t       bs_refresh;
  nasd_cheops_client_bs_qos_create_t    bs_qos_create;
  nasd_cheops_client_bs_create_t        bs_create;
  nasd_cheops_client_bs_remove_t        bs_remove;
  nasd_cheops_client_bs_getattr_t       bs_getattr;
  nasd_cheops_client_bs_setattr_t       bs_setattr;

  int                                   binding_type;
  char                                 *name;
  int                                   spec_size;

  nasd_cheops_client_rpcmod_tab_t      *next;
};

/*
 * Handle Management
 */
extern nasd_status_t nasd_bind_to_cheops_mgr(
  char *servername,
  char *portnum,
  int binding_type,
  void *binding_param,
  int binding_param_len,
  nasd_cheops_handle_t *handle);

extern nasd_status_t nasd_unbind_cheops_mgr(
  nasd_cheops_handle_t *handle);

struct nasd_cheops_default_bindings_s {
  int  *bindings;
  int   nbindings;
};

extern nasd_cheops_default_bindings_t *nasd_cheops_default_bindings;

/*
 * XXX Handle code cribbed substantially from the way the edrfs client
 * code does it, but perhaps not as nice.  Oh, well, this is better than
 * the way it was.
 */
struct nasd_cheops_handle_s {
  int				        type;
  void				       *rpc_specific_handle;
  int					rpc_specific_handle_size;
  nasd_cheops_client_rpcmod_tab_t      *rpc_tab;
  nasd_cheops_handle_t			next;
  nasd_cheops_handle_t			prev;
};

/*
 * Module Management
 */
extern nasd_status_t nasd_cheops_client_mods_init(
  nasd_shutdown_list_t *sl);
extern void nasd_cheops_client_mods_load(void);
extern void nasd_cheops_client_mod_register(
  nasd_cheops_client_rpcmod_tab_t *tab,
  int);
extern void nasd_cheops_client_mod_unregister(
  nasd_cheops_client_rpcmod_tab_t *tab,
  int);

/*
 * RPC wrappers
 */

extern void nasd_cheops_client_null(
  nasd_cheops_handle_t                  handle,
  nasd_status_t                         *nasd_status,
  nasd_rpc_status_t                     *status);

extern void nasd_cheops_client_bs_lookup(
  nasd_cheops_handle_t                  handle,
  nasd_cheops_bs_lu_args_t          *in_args,
  nasd_cheops_bs_lu_res_t           *out_res,
  nasd_rpc_status_t                     *out_status);

extern void nasd_cheops_client_mgr_lookup(
  nasd_cheops_handle_t                  handle,
  nasd_cheops_mgr_lu_args_t         *in_args,
  nasd_cheops_mgr_lu_res_t          *out_res,
  nasd_rpc_status_t                     *out_status);

extern void nasd_cheops_client_dr_lookup(
  nasd_cheops_handle_t			handle,
  nasd_cheops_dr_lu_args_t		*in_args,
  nasd_cheops_dr_lu_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

extern void nasd_cheops_client_bs_refresh(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_re_args_t		*in_args,
  nasd_cheops_bs_re_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

extern void nasd_cheops_client_bs_qos_create(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_qc_args_t	*in_args,
  nasd_cheops_bs_qc_res_t	*out_res,
  nasd_rpc_status_t			*op_status);

extern void nasd_cheops_client_bs_create(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_cr_args_t		*in_args,
  nasd_cheops_bs_cr_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

extern void nasd_cheops_client_bs_remove(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_rm_args_t		*in_args,
  nasd_cheops_bs_rm_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

extern void nasd_cheops_client_bs_getattr(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_ga_args_t		*in_args,
  nads_cheops_bs_ga_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

extern void nasd_cheops_client_bs_setattr(
  nasd_cheops_handle_t			handle,
  nasd_cheops_bs_sa_args_t		*in_args,
  nads_cheops_bs_sa_res_t		*out_res,
  nasd_rpc_status_t			*out_status);

#endif /* !_NASD__NASD_CHEOPS_CLIENT_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
