/*
 * nasd_linux_sys.h
 *
 * Linux-specific defines for system interface
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_LINUX_SYS_H_
#define _NASD__NASD_LINUX_SYS_H_

#ifndef KERNEL
#include <sys/errno.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#else /* !KERNEL */
#define MAXPATHLEN 1024
#include <asm/semaphore.h>
#endif /* !KERNEL */
#include <asm/ioctl.h>

typedef nasd_uint64 nasd_sys_dev_t;

#define NASD_MAX_IOCTL_SIZE ((1<<_IOC_SIZEBITS)-1)

#ifdef KERNEL

extern struct semaphore nasd_linux_d_sem;

#define NASD_D_LOCK()     down(&nasd_linux_d_sem)
#define NASD_D_UNLOCK()   up(&nasd_linux_d_sem)

extern void nasd_linux_set_kpdev_support(
  int support);
extern void nasd_linux_set_drive_launch(
  int (*launch)(nasd_svinfo_t *, void *),
  int does_colocate);
extern void nasd_linux_set_edrfs_launch(
  int (*launch)(nasd_edrfs_svinfo_t *));
extern void nasd_linux_kinit_once(void);

#endif /* KERNEL */

#endif /* !_NASD__NASD_LINUX_SYS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
