/*
 * nasd_linux_common.h
 *
 * Linux-specific shared header file for NASD entities - basic
 * prototypes for library functions
 *
 * Authors: Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_LINUX_COMMON_H_
#define _NASD__NASD_LINUX_COMMON_H_

#ifdef KERNEL
#include <linux/in.h>
#else /* KERNEL */
#include <netinet/in.h>
#endif /* KERNEL */

#define nasd_hton16(_v_) htons(_v_)
#define nasd_ntoh16(_v_) ntohs(_v_)
#define nasd_hton32(_v_) htonl(_v_)
#define nasd_ntoh32(_v_) ntohl(_v_)

extern int nasd_linux_nasd_status_to_errno(nasd_status_t nasd_status);

#define NASD_LINUX_SYSCALL_NO   247 /* XXX fix me, Sean */

#endif /* !_NASD__NASD_LINUX_COMMON_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
