/*
 * nasd_freebsd_platform.h
 *
 * Authors: Jim Zelenka, Sean Levy, Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_FREEBSD_PLATFORM_H_
#define _NASD__NASD_FREEBSD_PLATFORM_H_

#ifdef __LANGUAGE_C__
#define nasd_printf printf
#endif /* __LANGUAGE_C__ */

#if __i386__
#define nasd_int64cast(_n_)   _n_##LL
#define nasd_uint64cast(_n_)  _n_##ULL
#define NASD_64s_FMT          "qd"
#define NASD_64u_FMT          "qu"
#define NASD_64x_FMT          "qx"
#define NASD_64X_FMT          "qX"
#define NASD_ID_FMT           "016qx"
#endif /* __i386__ */

typedef const void * nasd_qsort_arg_type_t;

#define NASD_INLINE __inline

#endif /* !_NASD__NASD_FREEBSD_PLATFORM_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
