/*
 * nasd_edrfs_norpc.c
 *
 * "RPC" for no-RPC compilation
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE

#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_edrfs_internal.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_edrfs_rpc.h>
#include <nasd/nasd_timeout.h>

#include <nasd/nasd_pipe.h>

nasd_status_t
nasd_edrfs_rpc_specific_init()
{
  return(NASD_SUCCESS);
}

nasd_status_t
nasd_edrfs_rpc_specific_startup()
{
  return(NASD_SUCCESS);
}

void
nasd_edrfs_rpc_specific_stop()
{
}

nasd_status_t
nasd_edrfs_rpc_specific_listen(
  int  service_threads,
  nasd_uint16 ipport)
{
  nasd_delaycounter_t delayer;

  while(1) {
    /* keep sleeping for ten minutes */
    /* XXX do something better */
    NASD_BEGIN_DELAYCNT(&delayer);
    NASD_DELAY_FROM(&delayer, 10*60*NASD_USEC_PER_SEC);
  }
}

nasd_status_t
nasd_edrfs_rpc_specific_set_stacksize(
  int  stacksize)
{
  return(NASD_OP_NOT_SUPPORTED);
}

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
