/*
 * nasd_od_norpc.c
 *
 * "RPC" for no-RPC compilation
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE

#include <nasd/nasd_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_od_rpc.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_pipe.h>
#include <nasd/nasd_cache.h>

int nasd_drive_norpc_should_stop = 1;
NASD_DECLARE_COND(nasd_drive_norpc_cond)
NASD_DECLARE_MUTEX(nasd_drive_norpc_lock)

nasd_status_t
nasd_drive_rpc_specific_init()
{
  nasd_status_t rc;

  rc = nasd_cond_init(&nasd_drive_norpc_cond);
  if (rc)
    return(rc);
  rc = nasd_shutdown_cond(nasd_odc_shutdown, &nasd_drive_norpc_cond);
  if (rc)
    return(rc);

  rc = nasd_mutex_init(&nasd_drive_norpc_lock);
  if (rc)
    return(rc);
  rc = nasd_shutdown_mutex(nasd_odc_shutdown, &nasd_drive_norpc_lock);
  if (rc)
    return(rc);

  return(NASD_SUCCESS);
}

nasd_status_t
nasd_drive_rpc_specific_startup()
{
  nasd_drive_norpc_should_stop = 0;
  return(NASD_SUCCESS);
}

void
nasd_drive_rpc_specific_stop()
{
  nasd_drive_norpc_should_stop = 1;
  NASD_BROADCAST_COND(nasd_drive_norpc_cond);
}

nasd_status_t
nasd_drive_rpc_specific_listen(
  int          service_threads,
  nasd_uint16  ipport)
{
  nasd_status_t rc;

  NASD_LOCK_MUTEX(nasd_drive_norpc_lock);
  while(nasd_drive_norpc_should_stop == 0) {
    NASD_WAIT_COND(nasd_drive_norpc_cond, nasd_drive_norpc_lock);
  }
  NASD_UNLOCK_MUTEX(nasd_drive_norpc_lock);

  return(NASD_SUCCESS);
}

nasd_status_t
nasd_drive_rpc_specific_set_stacksize(
  int  stacksize)
{
  return(NASD_OP_NOT_SUPPORTED);
}

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
