/*
 * _sio_timer.c - timers for sio operations
 */

typedef struct _sio_timer_s _sio_timer_t;
struct _sio_timer_s {
  _sio_timer_t		*next;
  char			*name;
  nasd_timer_t		timer;
};

static _sio_timer_t *timer_list = NULL;

static_sio_timer_t *
find_timer(char *name, _sio_timer_t **eol)
{
  _sio_timer_t *t;
  _sio_timer_t *last_t;

  for (last_t = NULL, t = timer_list; t; last_t = t, t = t->next)
    if (!strcmp(t->name, name)) {
      *eol = NULL;
      return t;
    }
  *eol = last_t;
  return NULL;
}

void
_sio_timer_start(char *name)
{
  _sio_timer_t *t;
  _sio_timer_t *last_t = NULL;

  t = find_timer(name, &last_t);
  if (t)
    NASD_TM_START(&t->timer);
}

void
_sio_timer_stop(char *name)
{
}

void
_sio_dump_timers(void)
{
}
