#ifndef	UARTDMP_HPP
#define	UARTDMP_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/7/00
*
*****************************************************************************
*
* File Name:		UartDmp.hpp
* Module:
* Contributors:	Karla Summers
* Description:
* Version Control:
*
* $Revision: 3 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

class UartDmp:public Command
{

	public:
		UartDmp::UartDmp(int hbaNo, char *fileName);
		UartDmp(const UartDmp &new_UartDmp);
		virtual	~UartDmp();

		Dpt_Error execute(String_List **output);
      Dpt_Error UartDmpHba(DPT_TAG_T hbaTag, char *hbaOutStr, 
         int hbaNbr, String_List *out);
      Dpt_Error ViewUartDmp (String_List *out, DPT_TAG_T obj_Tag);
		Command &Clone() const;

	private:
      int hbaNum;
      bool anyDataOut;
      char *dumpFileName;
      FILE *outFile_P;
};

#endif
/*** END OF FILE ***/
