//File - SWAP_EM.C
//***************************************************************************
//
//Description:
//
//	This file contains the definitions for the functions to reverse
//the byte ordering of 2 and 4 byte variables.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author: Bob Roycroft
//Date:   06/20/94
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************

//Include Files -------------------------------------------------------------

#include        "osd_util.h"

//Function - osdSwap4() - start
//===========================================================================
//
//Description:
//
//    This function reverses the byte ordering of a four byte variable.
//
//Parameters:
//
//   inLong_P = Pointer to the 4 byte variable to be byte reversed.
//
//Return Value:
//
//   The byte reversed variable.
//   Note that the input variable is also reversed.
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

#ifndef _DPT_NETWARE
uLONG   osdSwap4(DPT_UNALIGNED uLONG * dwdp)
{

#ifndef _DPT_BIG_ENDIAN
uSHORT	wd0, wd1;

    wd0 = (uSHORT) *dwdp;
    wd1 = (uSHORT) (*dwdp>>16);
    wd0 = ((uSHORT) ((wd0>>8) | (wd0<<8)));
    wd1 = ((uSHORT) ((wd1>>8) | (wd1<<8)));
    return (* dwdp = (((uLONG)wd0<<16) | wd1));
#else
	return *dwdp;
#endif
}
#endif

//Function - osdSwap2() - start
//===========================================================================
//
//Description:
//
//    This function swaps the MSB & LSB of a two byte variable.
//
//Parameters:
//
//   inShort_P = Pointer to the 2 byte variable to be byte reversed.
//
//Return Value:
//
//   The byte reversed variable
//   Note that the input variable is also reversed.
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

uSHORT	osdSwap2(DPT_UNALIGNED uSHORT * wdp)
{
#ifndef _DPT_BIG_ENDIAN
    return (* wdp = ((uSHORT) (((*wdp>>8) | (*wdp<<8)))));
#else
	return *wdp;
#endif
}

//Function - osdSwap3() - start
//===========================================================================
//
//Description:
//
//    This function reverses the byte ordering of a three byte variable.
//
//Parameters:
//
//   inLong_P = Pointer to the 4 byte variable to be byte reversed.
//
//Return Value:
//
//   The byte reversed variable.
//   Note that the input variable is also reversed.
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

uLONG	osdSwap3(DPT_UNALIGNED uLONG * dwdp)
{

#ifndef _DPT_BIG_ENDIAN
uSHORT	wd0, wd1;

    wd0 = (uSHORT) *dwdp;
    wd1 = (uSHORT) (*dwdp>>16);
    wd0 = ((uSHORT) ((wd0>>8) | (wd0<<8)));
    wd1 = ((uSHORT) ((wd1>>8) | (wd1<<8)));
    return (* dwdp = ((((uLONG)wd0<<16) | wd1) >> 8));
#else
	return *dwdp;
#endif
}


/*Function - trueSwap2 - start                                               */
/*===========================================================================*/
/*                                                                           */
/*Description:                                                               */
/*                                                                           */
/*    This function ALWAYS swaps the MSB & LSB of a two byte variable.       */
/*                                                                           */
/*Parameters:                                                                */
/*                                                                           */
/*Return Value:                                                              */
/*                                                                           */
/*Global Variables Affected:                                                 */
/*                                                                           */
/*Remarks: (Side effects, Assumptions, Warnings...)                          */
/*                                                                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/

uSHORT     trueSwap2(uSHORT *inShort)
{
  uSHORT i;

  i = (uSHORT) (*inShort & 0x0ff);
  *inShort >>= 8;
  *inShort |= (i << 8); 
  return(*inShort);

}
/* trueSwap2() - end                                                         */


/*Function - trueSwap4 - start                                               */
/*===========================================================================*/
/*                                                                           */
/*Description:                                                               */
/*                                                                           */
/* This function ALWAYS reverses the byte ordering of a four byte variable.  */
/*                                                                           */
/*Parameters:                                                                */
/*                                                                           */
/*Return Value:                                                              */
/*                                                                           */
/*Global Variables Affected:                                                 */
/*                                                                           */
/*Remarks: (Side effects, Assumptions, Warnings...)                          */
/*                                                                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/

uLONG     trueSwap4(uLONG *inLong)
{
  char src[4], *dst;
  int i;

  *(uLONG *)src =  *inLong;
  dst = (char *)inLong;
  for(i = 0; i < 4; ++i)
   {
     dst[i] = src[3 - i]; 
   }
  return(*inLong);

}
/* trueSwap4() - end                                                        */



//Function - netSwap4() - start
//===========================================================================
//
//Description:
//
//    This function ensures that the input four byte variable is returned
//    in DPT network order (little-endian).  On big-endian machines this
//    function will swap the four byte variable.  On little-endian machines
//    this function will return the input value.
//
//Parameters:
//
//   val = 4 byte variable to be byte reversed.
//
//Return Value:
//
//   The variable in network order.
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------
uLONG netSwap4(uLONG val)
{
#if defined (_DPT_BIG_ENDIAN)
   
   // we need to swap the value and return it
   uSHORT  wd0, wd1;

   wd0 = (uSHORT) val;
   wd1 = (uSHORT) (val >> 16);
   wd0 = (wd0 >> 8) | (wd0 << 8);
   wd1 = (wd1 >> 8) | (wd1 << 8);

   return (((uLONG)wd0 << 16) | wd1);

#else

   // just return the value for little-endian machines
   return val;

#endif  // big_endian
}
//netSwap4() - end


