#ifndef	SCSILIST_HPP
#define	SCSILIST_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/98
*
*****************************************************************************
*
* File Name:		ScsiList.hpp
* Module:
* Contributors:		Lee Page
* Description:      This file serves as a container class, holding a list of scsi
					addresses.
* Version Control:
*
* $Revision: 7 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "scsiaddr.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

class SCSI_Addr_List
	{
	public:
		SCSI_Addr_List();
		SCSI_Addr_List( const SCSI_Addr_List &right );
		~SCSI_Addr_List();
		SCSI_Addr_List	&operator += ( const SCSI_Addr_List &right );
		const SCSI_Addr_List & operator = ( const SCSI_Addr_List &right );

		void	add_Item( const SCSI_Address &address );

		//	Fetches the nth str (0 based).  The user should not
		//	deallocate the returned address.  It is owned by the
		//	object.
		SCSI_Address	&get_Item( int index ) const;

		//	Fetches the next address.  The user should not deallocate
		//	the returned address.  It is owned by the object.
		SCSI_Address	&get_Next_Item();
		// FIFO.  Removes the first item from the list, and returns it.
		SCSI_Address	shift_Item();

		//	Resets the get_Next_Address index to point to the first item.
		void	reset_Next_Index();
		// returns the number of entries minus the index
		int		num_Left() const;
		int		get_Num_Items() const	{ return( num_Items ); }

      // returns true if addr is already in the list, false otherwise 
      bool In_List (const SCSI_Address &addr);

	private:
		void	Destroy_Items();
		void	Copy_Items( const SCSI_Addr_List &right );

		int				num_Items;
		SCSI_Address	**items;
		int				next_Item_Index;
	};

#endif
/*** END OF FILE ***/
