#ifndef	SCSIADDR_HPP
#define	SCSIADDR_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/22/98
*
*****************************************************************************
*
* File Name:		ScsiAddr.hpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
/*** CONSTANTS ***/
/*** TYPES ***/
class	SCSI_Address
	{
	public:
		SCSI_Address():
			hba( 0 ),
			bus( 0 ),
			id( 0 ),
			lun( 0 ),
			level( 0 )
			{}

		SCSI_Address(
			int new_HBA,
			int	new_Bus		= 0,
			int	new_ID		= 0,
			int	new_Lun		= 0,
			int	new_Level	= 0	// this is NOT the engine levels, this is 0 == physicals...
			):
			hba( new_HBA ),
			bus( new_Bus ),
			id( new_ID ),
			lun( new_Lun ),
			level( new_Level )
			{}

		SCSI_Address( const SCSI_Address &right )
			{
			hba		= right.hba;
			bus		= right.bus;
			id		= right.id;
			lun		= right.lun;
			level	= right.level;
			}

		int hba;
		int	bus;
		int	id;
		int	lun;
		int	level;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
