/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  8/6/98
*
*****************************************************************************
*
* File Name:		Usage.cpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "rawdata.hpp"

/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#define DPT_ENGINE_COMPATIBILITY 4
#define BufferLength 256


RawData::RawData()
	{
	ENTER( "RawData::RawData()" );

	EXIT();
	}

RawData::~RawData()
	{
	ENTER( "RawData::~RawData()" );

	EXIT();
	}

Command::Dpt_Error	RawData::execute( String_List **output )
	{
	ENTER( "Command::Dpt_Error	RawData::execute( String_List **output )" );

	String_List *out;
	Init_Engine(1);
	*output = out = new String_List();
	uCHAR SCSIcmd[12] = "";
	uCHAR returned[BufferLength];
	char rtnBuff[BufferLength];
	memset(rtnBuff,NULL,sizeof(rtnBuff));

	DPT_RTN_T rtnVal;
	int i = 0;

	// Scan the SCSI sub-system
	if (engine->Send(MSG_IO_SCAN_SYSTEM) == MSG_RTN_COMPLETED) 
	{
		// Check DASDs for SMART status
		if (engine->GetIDs(MSG_ID_ALL_PHYSICALS) == MSG_RTN_COMPLETED) 
		{
			engine->ids.Next(); //skip the RAID controller
			if (engine->ids.GetID()) 
			{
				engine->Reset();
				engine->Insert((uSHORT) 0x80); // control flag
				engine->Insert((uLONG) 255);          // data length
				SCSIcmd[0] = SC_INQUIRY; 
				SCSIcmd[1] = 0;  				
				SCSIcmd[2] = 0;  				//page 00
				SCSIcmd[3] = 0;  
				SCSIcmd[4] = 255; 
				SCSIcmd[5] = 0; 

				engine->Insert(&SCSIcmd, 12);
				do
				{
					if ((rtnVal = engine->Send(MSG_SCSI_CMD, engine->ids.tag)) == MSG_RTN_COMPLETED) 
					{
						engine->Extract(&returned, 256);
						for (i=0; i <= returned[4]; i++)
						{
							if (i < 8)
								sprintf(rtnBuff+i,"%x",returned[i]);
							else
								sprintf(rtnBuff+i,"%c",returned[i]);
						}
					}	
					out->add_Item(rtnBuff);
					out->add_Item("\n");
					memset(rtnBuff,NULL,sizeof(rtnBuff));
				} while (engine->ids.Next());
			}
		}
	}
	EXIT();
	return( Command::Dpt_Error::DPT_CMD_ERR_NO_ERROR );
	}

Command		&RawData::Clone() const
	{
	ENTER( "Command		&RawData::Clone() const" );
	EXIT();
	return( *new RawData( *this ) );
	}

/*** END OF FILE ***/
