#ifndef	PARSERR_HPP
#define	PARSERR_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/98
*
*****************************************************************************
*
* File Name:		ParsErr.hpp
* Module:
* Contributors:		Lee Page
* Description:		This is used for encapsulating errors encountered in parsing.
					Errors in parsing only halt the execution of subsequent commands,
					not previous commnads that parsed right (I think).
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
class Parse_Error:public Command
	{
	public:
		Parse_Error( char *error_Str, char *command_Line );
		Parse_Error( const Parse_Error &right );
		virtual	~Parse_Error();
		// This executes the command that this object represents.  This returns an "String_List"
		// object.  The reason it returns this rather than printing to the screen
		// is to allow the caller complete control over how the strings are given
		// to the user (if at all).
		Dpt_Error	execute( String_List **output );
		Command		&Clone() const;

	private:
		String_List	*err_Str;
	};

#endif
/*** END OF FILE ***/
