/****************************************************************************
*
* Copyright (C) 1996-2000 Distributed Processing Technology.  All Rights Reserved.
* Copyright (C) 2000-2001 Adaptec Corporation.  All Rights Reserved.
*
* Created:  7/24/98
*
*****************************************************************************
*
* File Name:		ParsArgv.cpp
* Module:
* Contributors:		Lee Page
* Description:		This specialization class accepts an argv parameter and converts
					it to a concatenated string, that is then passed in to the Parser
					ctor to construct that.
* Version Control:
*
* $Revision: 6 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "parsargv.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

Parse_Argv::Parse_Argv(
			char	*argv[],
 			bool	*new_Quiet_Mode
			): Parser( Concatenate_Argv( argv ), new_Quiet_Mode )
{
	ENTER( "Parse_Argv::Parse_Argv(" );

	EXIT();
}

Parse_Argv::~Parse_Argv()
{
	ENTER( "Parse_Argv::~Parse_Argv()" );

	EXIT();
}

/****************************************************************************
*
* Function Name:	Concatenate_Argv(),	Created:7/24/98
*
* Description:      Convert the argv array into a single string.
*
* Return:			char * containing the concatenated argv array.
*
* Notes:
*
*****************************************************************************/

char	*Parse_Argv::Concatenate_Argv( char *argv[] )
{
	ENTER( "char	*Parse_Argv::Concatenate_Argv( char *argv[] )" );
	int	argv_Index;

	concatenated_Argv_Buf[ 0 ]	= 0;

	for( argv_Index = 0; argv[ argv_Index ]; argv_Index++ )
	{
		char * is_white_space = argv[ argv_Index ];

		/* If an argument has embedded white space, lets quote it */
		if ((*is_white_space != '\'')
		 && (*is_white_space != '"')
		 && (*is_white_space != '`'))
		for (;*is_white_space
		  && (*is_white_space != ' ')
		  && (*is_white_space != '\t')
		  && (*is_white_space != '\n')
		  && (*is_white_space != '\r');
		  ++is_white_space);
		if ((is_white_space != argv[ argv_Index ])
		 && (*is_white_space != '\0'))
		{
			strcat( concatenated_Argv_Buf, "\"");
			strcat( concatenated_Argv_Buf, argv[ argv_Index ] );
			strcat( concatenated_Argv_Buf, "\"");
		} else
			strcat( concatenated_Argv_Buf, argv[ argv_Index ] );
		// make sure that we have whitespace delimiting separate arguments
		strcat( concatenated_Argv_Buf, " " );
	}

	EXIT();
	return( concatenated_Argv_Buf );
}

/*** END OF FILE ***/
