#ifndef	FORCEST_HPP
#define	FORCEST_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/99
*
*****************************************************************************
*
* File Name:		ForceSt.hpp
* Module:
* Contributors:		Karla Summers
* Description:
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
#define STR_FORCE_FAIL_WARNING "This action will fail this drive.  Are you sure you want to do this? [yN]"
#define STR_FORCE_OPTIMAL_WARNING "Forcing an array to optimal will not reconstruct any data and could lead to corruption or data loss!  Are you sure you want to make this array optimal? [yN]"
/*** TYPES ***/

enum ForceStateOptions { Optimal, Fail, Current };

/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

class ForceState:public Command
	{
	public:
		ForceState::ForceState(SCSI_Addr_List *deviceList, ForceStateOptions cmd);
		ForceState(const ForceState &new_ForceState);
		virtual	~ForceState();

		Dpt_Error execute(String_List **output);
		Command &Clone() const;

	private:
		ForceStateOptions toState;
		SCSI_Addr_List *objsToCtrl;
	};

#endif
/*** END OF FILE ***/
