#ifndef	EVENTLOG_HPP
#define	EVENTLOG_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  6/16/99
*
*****************************************************************************
*
* File Name:		EventLog.hpp
* Module:
* Contributors:		      Karla Summers
* Description:
* Version Control:
*
* $Revision: 7 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include <time.h>
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

enum EventLogOptions { Soft = 1, Recov, Nonrecov, StatusChg, Delete, Board };
enum vl_LogTypes { LT_PHYSICAL, LT_LOGICAL, LT_HBA };

static void GetSesTypeAndStatus(uCHAR SesType, char *TypeString,
    uCHAR SesStatus,char *StatusString);
static void DoTime(uLONG ti, uSHORT level, String_List *out);
static void GetGen5HbaErrorString(uCHAR ErrorCode, char *ErrorString);
static void DoBytes (uSHORT numbytes, uCHAR *bytes, String_List *out);
static void DoLongs (uSHORT numlongs, uLONG *longs, String_List *out);
static int bufcat(String_List *out, char *source, ...);
void SetScsiAddr(dptHBAlog_C log, int offset, 
                 uSHORT *ID, uSHORT *CHAN, uSHORT *LUN);
void LogRaidStatus(uCHAR level, uCHAR status, char *buf);


class EventLog:public Command
	{

	public:
		EventLog::EventLog(SCSI_Addr_List *deviceList, 
            EventLogOptions cmd);
		EventLog(const EventLog &new_EventLog);
		virtual	~EventLog();

		Dpt_Error execute(String_List **output);
		Dpt_Error ViewEventLog(DPT_TAG_T dev_Tag, 
		         SCSI_Address obj_Address, String_List *out);
      void DisplayEvents(int keepgoing, dptHBAlog_C log, 
                         String_List *out, SCSI_Address obj_Address);
      bool validateBuffer(dptBuffer_S *logbuf_P, 
         char *tempBuf_P);
      bool CheckTime(uLONG ti);
		Command &Clone() const;

	private:
      EventLogOptions eventCmd;
      SCSI_Addr_List *devsToCtrl;
      int ourViewThreshold;
      time_t currentTime;
      uLONG totalbytes;
	};

#endif
/*** END OF FILE ***/
