/*
 * Copyright (c) 1999 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 *
 * UNIX locking mechanism
 */

#if (defined(__cplusplus))
extern "C" {
#endif

#if (!defined(__P))
# define __P(x)	x
#endif

/*
 *	Establish a lock
 *		returns negative on failure
 *				0 upon successfull lock
 *				positive on someone else owning the lock.
 */
int MkLock __P((char * name));

/*
 *	Cleanup on exit
 */
void RmLock __P((char * name));

/*
 *	Change who (pid) owns the lock (done within a daemon fork).
 */
void ChLock __P((char * name, int pid));

/*
 *	Check for an existing lock
 *		returns negative on failure (retry again later, task likely exiting)
 *				0 if no one is locked
 *				positive if someone owns the lock.
 */
int IsLock __P((char * name));

#if (defined(__cplusplus))
}
#endif
