#ifndef         __GBL_FNS_HPP
#define		__GBL_FNS_HPP

//File - GBL_FNS.HPP
//***************************************************************************
//
//Description:
//
//    This file contains prototypes of stand alone functions that are
//used globally throughout the DPT engine.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		5/10/94
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//==============
// Include Files
//==============

#include	"eng_std.hpp"


//=================================
// Constants used in function calls
//=================================

  // 1=Traverse sub-managers' physical object lists
const uSHORT	OPT_TRAVERSE_PHY	= 0x0010;
  // 1=Traverse sub-managers' logical device lists
const uSHORT	OPT_TRAVERSE_LOG	= 0x0011;
     // 1=Traverse RAID device component list
const uSHORT	OPT_TRAVERSE_COMP	= 0x0012;

//====================
// Function Prototypes
//====================

uSHORT		positionSCSI(dptCoreList_C &,dptAddr_S);
uSHORT		isUniqueAddr(dptCoreList_C &,dptAddr_S,uCHAR);
DPT_RTN_T	rtnIDfromList(dptCoreList_C &,dptBuffer_S *,dptBuffer_S *,uSHORT);

DPT_RTN_T	rtnFromList(dptCoreList_C &,dptBuffer_S *&,
			    uSHORT,uSHORT,uSHORT,uSHORT);
uSHORT		findSubString(uCHAR *,uCHAR *,uSHORT=0xffff,uSHORT=0xffff,uCHAR=1);
uSHORT		strSize(uCHAR *&,uSHORT=0xffff);
uCHAR		upCh(uCHAR inChar);
char		upCh(char inChar);
uSHORT		findDASD(dptCoreList_C &);
void		upperCase(uCHAR *);
dptObject_C *	findObjectAt(dptCoreList_C &,dptAddr_S);
dptDevice_C *	findMagicObject(dptCoreList_C &list,uLONG,uINT=0);
dptDevice_C *	findDeviceFromTag(dptCoreList_C &list,DPT_TAG_T,uINT=0);


#endif


