#ifndef	ZAP_HPP
#define	ZAP_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  10/21/98
*
*****************************************************************************
*
* File Name:		Zap.hpp
* Module:
* Contributors:		Mark Salyzyn <salyzyn@dpt.com>
* Description:
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
class Zap:public Command
	{
	public:
		Zap::Zap(
				SCSI_Addr_List	*addresses,  // a list of addresses
            int resync = 0            // (send reset to hba or not)
      );								         // to delete raid tables on
		Zap( const Zap &new_Zap );
		virtual	~Zap();
		Zap	&operator = ( Zap &right );

		Dpt_Error		execute(			String_List	**output );
		Command			&Clone() const;

	private:
		void AddRaid( Int_List *component_List, DPT_TAG_T parent_Tag );

		SCSI_Addr_List	*address_List;
      int Resync;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
