#ifndef	SEGMENT_HPP
#define	SEGMENT_HPP

/****************************************************************************
*
* File Name:		segment.hpp
* Contributors:		Edrick Estrada
* Description:		Class that enables functionality for segmentation in HBAs 
*					that are segmentation compatible
* *****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/

/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

class arraySegment:public Command
{

	public:
		arraySegment::arraySegment(SCSI_Address raidToSeg, uLONG segSize[8], uLONG segOffset[8], bool showSeg);
		arraySegment(const arraySegment &new_arraySegment);
		virtual	~arraySegment();

		Dpt_Error execute(String_List **output);
		DPT_RTN_T getSegmentData(DPT_TAG_T raidTag, arraySegment_S *segData);
		DPT_RTN_T showSegmentData(DPT_TAG_T raidTag, String_List &output);
		Command &Clone() const;

	private:
		
		SCSI_Address raidToSegment;
		DPT_TAG_T raidToSegmentTag;
		uLONG *segSizeArray;
		uLONG *segOffsetArray;
		static uSHORT segArrayCt;
		bool showArraySegData;
		uLONG	arraySizeInBlks;
		uLONG	segmentAlignment;

};

#endif
/*** END OF FILE ***/
