/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/98
*
*****************************************************************************
*
* File Name:		ParsErr.cpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "parserr.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
Parse_Error::Parse_Error( char *error_Str, char *command_Line )
	{
	ENTER( "Parse_Error::Parse_Error( char *error_Str, char *command_Line )" );
	err_Str	= new String_List();

	err_Str->add_Item( error_Str );
	err_Str->add_Item( command_Line );
	err_Str->add_Item( "\n" );
	EXIT();
	}

Parse_Error::Parse_Error( const Parse_Error &right )
	{
	ENTER( "Parse_Error::Parse_Error( const Parse_Error &right )" );
	err_Str	= new String_List( *right.err_Str );
	EXIT();
	}

Parse_Error::~Parse_Error()
	{
	ENTER( "Parse_Error::~Parse_Error()" );
	// delete this object here in case the execute method was never called.
	delete	err_Str;
	EXIT();
	}

Command::Dpt_Error	Parse_Error::execute( String_List **output )
	{
	ENTER( "Command::Dpt_Error	Parse_Error::execute( String_List **output )" );
	Dpt_Error	err;
	*output	= err_Str;
	// the caller is responsible for deleting this, make sure we don't delete it
	// in the dtor.
	err_Str	= 0;

	EXIT();
	return( err );
	}

Command	&Parse_Error::Clone() const
	{
	ENTER( "Command	&Parse_Error::Clone() const" );
	EXIT();
	return( *new Parse_Error( *this ) );
	}

/*** END OF FILE ***/
