#ifndef	EXPAND_HPP
#define	EXPAND_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  12/17/99
*
*****************************************************************************
*
* File Name:		Expand.hpp
* Module:
* Contributors:	Karla Summers
* Description:
* Version Control:
*
* $Revision: 1 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
class Expand:public Command
{
   public:
      Expand::Expand (SCSI_Address raid, SCSI_Addr_List *list);
		Expand (const Expand &new_Expand);
		virtual ~Expand();
		Expand &operator = (Expand &right);
		Dpt_Error execute (String_List **output);
		Command &Clone () const;

	private:
      Dpt_Error RaidExpandable (void);
      bool StripeSizeCapable (DPT_TAG_T compTag);

      SCSI_Address raidToExpandAddr;
      DPT_TAG_T raidToExpandTag;
      DPT_TAG_T mgrTag;
      uSHORT raidToExpandType;
      uLONG maxStripeSize;

      SCSI_Addr_List *components;
      uLONG raidStripeSize;
      uLONG currStripeSize;

      typedef struct {
         uCHAR arrayFlags;
         uCHAR raidType;
         uCHAR pad[2];
      } smUserBuff_S;
};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
