#ifndef         __ENGINE_H
#define         __ENGINE_H

//File - ENGINE.H
//***************************************************************************
//
//Description:
//
//      This file contains the function prototypes for the global
//engine functions that may be exported.
//
//Copyright Distributed Processing Technology, Corp.
//        140 Candace Dr.
//        Maitland, Fl. 32751   USA
//        Phone: (407) 830-5522  Fax: (407) 260-5366
//        All Rights Reserved
//
//Author:       Doug Anderson
//Date:         5/26/94
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


#include	"osd_util.h"
#include	"eng_std.h"

#ifdef		_DPT_WIN_NT
   #include	"eng_osd.h"
#endif

//Prototypes - function -----------------------------------------------------

#ifdef  __cplusplus
   extern "C" {
#endif

#if defined (_DPT_ERGO) || defined (_DPT_MSDOS)
   #ifdef	_DPT_ENGINE
      DPT_RTN_T DPT_EXPORT  DPT_StartEngine(void);
      DPT_RTN_T DPT_EXPORT  DPT_StopEngine(void);
   #else
      DPT_RTN_T DPT_IMPORT  DPT_StartEngine(void);
      DPT_RTN_T DPT_IMPORT  DPT_StopEngine(void);
   #endif
#else
   DPT_RTN_T DPT_StartEngine(void);
   DPT_RTN_T DPT_StopEngine(void);
#endif

#ifdef	_DPT_ENGINE
   DPT_RTN_T DPT_EXPORT  DPT_Engine(DPT_TAG_T,DPT_MSG_T,DPT_TAG_T,void *,void *,uLONG);
#elif !defined(_MANUAL_DLL_LOAD)
   DPT_RTN_T DPT_IMPORT  DPT_Engine(DPT_TAG_T,DPT_MSG_T,DPT_TAG_T,void *,void *,uLONG);
   #ifdef	_DPT_WIN_NT
      DPT_RTN_T DPT_IMPORT DPT_PassThru(uSHORT,dptCCB_S *);
   #endif
#endif

#ifdef  __cplusplus
   };
#endif

#endif


