#ifndef         __DYNSIZE_H
#define         __DYNSIZE_H

/****************************************************************************
*
* Copyright (C) 2000 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  1/18/2000
*
*****************************************************************************
*
* File Name:		DynSize.h
* Module:           Generic
* Contributors:		David Dillard
* Description:		Contains the declaration of the DynamicSizeInStreamBuf
*                   class.
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include <iostream.h>
#include <stdio.h>


/*** DEFINES ***/
#ifdef _DPT_DOS
#define MaxBufSize          (24 * 1024)
#else
#define MaxBufSize          ((unsigned) 63 * (unsigned) 1024)
#endif
#define MinBufSize          1024
#define BufSizeDecrement    2048





//Class - DynamicSizeInStreamBuf
//===========================================================================
//
//Description:
//
//  This class is a base class for other streambuf classes which wish to
//  dynamically adjust to the amount of memory that is available to the
//  application.  This is particularly useful in a DOS environment, where
//  memory is inherently a scarce resource.
//
//---------------------------------------------------------------------------
class DynamicSizeInStreamBuf : public streambuf
{

protected:
    //
    // Allocates a maximually sized buffer based on the maximum, minimum, and
    // decrement sizes specified.
    //
    size_t AllocBuf(
        size_t maxSize,
        size_t minSize,
        size_t decrementSize
    );



    //
    // Allocates a maximually sized buffer based on some defaults and the
    // the amount of available memory.
    //
    inline size_t AllocBuf(void)
    {
        return(AllocBuf(MaxBufSize, MinBufSize, BufSizeDecrement));
    }
};


#endif
