#ifndef	DEBUG_HPP
#define	DEBUG_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  9/11/98
*
*****************************************************************************
*
* File Name:		debug.hpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 1 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include <stdio.h>
/*** CONSTANTS ***/
/*** TYPES ***/
#ifdef DEBUG_ENTER_EXIT
class Enter_Exit
	{
	public:
		Enter_Exit( char *name )
			{
			func_Name	= name;

			if( show_Enters )
				{
				printf( "%s>> %s\n", Generate_Spaces( ++indent_Counter ), func_Name );
				}
			}

  		~Enter_Exit()
			{
			if( show_Enters )
				{
				printf( "%s<< %s\n", Generate_Spaces( indent_Counter-- ), func_Name );
				}
			}

		static void	Set_Show_Enters()	{ show_Enters = true; }
		static void	Clear_Show_Enters()	{ show_Enters = false; }

	private:
		char		*func_Name;
		static bool	show_Enters;
		static int	indent_Counter;
		// generates num_Spaces spaces in the buf
		char	*Generate_Spaces( int num_Spaces )
					{
					static char	space_Buf[ 80 ];
					int			space_Index;

					for( space_Index = 0; space_Index < num_Spaces; space_Index++ )
						{
						space_Buf[ space_Index ]	= ' ';
						}

					// null terminate it
					space_Buf[ space_Index ]	= 0;
					return( space_Buf );
					}

	};
#endif
/*** STATIC DATA ***/
/*** MACROS ***/
#ifdef DEBUG_ENTER_EXIT
	#define	ENTER( str )    Enter_Exit enter_Exit( str );
	#define	EXIT()
#else
	#define	ENTER( str )
	#define	EXIT()
#endif
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
